package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SingleCallByVoice invokes the dyvmsapi.SingleCallByVoice API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/singlecallbyvoice.html
func (client *Client) SingleCallByVoice(request *SingleCallByVoiceRequest) (response *SingleCallByVoiceResponse, err error) {
	response = CreateSingleCallByVoiceResponse()
	err = client.DoAction(request, response)
	return
}

// SingleCallByVoiceWithChan invokes the dyvmsapi.SingleCallByVoice API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/singlecallbyvoice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SingleCallByVoiceWithChan(request *SingleCallByVoiceRequest) (<-chan *SingleCallByVoiceResponse, <-chan error) {
	responseChan := make(chan *SingleCallByVoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SingleCallByVoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SingleCallByVoiceWithCallback invokes the dyvmsapi.SingleCallByVoice API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/singlecallbyvoice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SingleCallByVoiceWithCallback(request *SingleCallByVoiceRequest, callback func(response *SingleCallByVoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SingleCallByVoiceResponse
		var err error
		defer close(result)
		response, err = client.SingleCallByVoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SingleCallByVoiceRequest is the request struct for api SingleCallByVoice
type SingleCallByVoiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Speed                requests.Integer `position:"Query" name:"Speed"`
	CalledNumber         string           `position:"Query" name:"CalledNumber"`
	VoiceCode            string           `position:"Query" name:"VoiceCode"`
	CalledShowNumber     string           `position:"Query" name:"CalledShowNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PlayTimes            requests.Integer `position:"Query" name:"PlayTimes"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Volume               requests.Integer `position:"Query" name:"Volume"`
	OutId                string           `position:"Query" name:"OutId"`
}

// SingleCallByVoiceResponse is the response struct for api SingleCallByVoice
type SingleCallByVoiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CallId    string `json:"CallId" xml:"CallId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSingleCallByVoiceRequest creates a request to invoke SingleCallByVoice API
func CreateSingleCallByVoiceRequest() (request *SingleCallByVoiceRequest) {
	request = &SingleCallByVoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "SingleCallByVoice", "dyvms", "openAPI")
	return
}

// CreateSingleCallByVoiceResponse creates a response to parse from SingleCallByVoice response
func CreateSingleCallByVoiceResponse() (response *SingleCallByVoiceResponse) {
	response = &SingleCallByVoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
