package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMaintenanceProperty invokes the ecs.DeleteMaintenanceProperty API synchronously
// api document: https://help.aliyun.com/api/ecs/deletemaintenanceproperty.html
func (client *Client) DeleteMaintenanceProperty(request *DeleteMaintenancePropertyRequest) (response *DeleteMaintenancePropertyResponse, err error) {
	response = CreateDeleteMaintenancePropertyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMaintenancePropertyWithChan invokes the ecs.DeleteMaintenanceProperty API asynchronously
// api document: https://help.aliyun.com/api/ecs/deletemaintenanceproperty.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMaintenancePropertyWithChan(request *DeleteMaintenancePropertyRequest) (<-chan *DeleteMaintenancePropertyResponse, <-chan error) {
	responseChan := make(chan *DeleteMaintenancePropertyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMaintenanceProperty(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMaintenancePropertyWithCallback invokes the ecs.DeleteMaintenanceProperty API asynchronously
// api document: https://help.aliyun.com/api/ecs/deletemaintenanceproperty.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMaintenancePropertyWithCallback(request *DeleteMaintenancePropertyRequest, callback func(response *DeleteMaintenancePropertyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMaintenancePropertyResponse
		var err error
		defer close(result)
		response, err = client.DeleteMaintenanceProperty(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMaintenancePropertyRequest is the request struct for api DeleteMaintenanceProperty
type DeleteMaintenancePropertyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
}

// DeleteMaintenancePropertyResponse is the response struct for api DeleteMaintenanceProperty
type DeleteMaintenancePropertyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMaintenancePropertyRequest creates a request to invoke DeleteMaintenanceProperty API
func CreateDeleteMaintenancePropertyRequest() (request *DeleteMaintenancePropertyRequest) {
	request = &DeleteMaintenancePropertyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteMaintenanceProperty", "ecs", "openAPI")
	return
}

// CreateDeleteMaintenancePropertyResponse creates a response to parse from DeleteMaintenanceProperty response
func CreateDeleteMaintenancePropertyResponse() (response *DeleteMaintenancePropertyResponse) {
	response = &DeleteMaintenancePropertyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
