package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePublicWhiteIps invokes the elasticsearch.UpdatePublicWhiteIps API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatepublicwhiteips.html
func (client *Client) UpdatePublicWhiteIps(request *UpdatePublicWhiteIpsRequest) (response *UpdatePublicWhiteIpsResponse, err error) {
	response = CreateUpdatePublicWhiteIpsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePublicWhiteIpsWithChan invokes the elasticsearch.UpdatePublicWhiteIps API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatepublicwhiteips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdatePublicWhiteIpsWithChan(request *UpdatePublicWhiteIpsRequest) (<-chan *UpdatePublicWhiteIpsResponse, <-chan error) {
	responseChan := make(chan *UpdatePublicWhiteIpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePublicWhiteIps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePublicWhiteIpsWithCallback invokes the elasticsearch.UpdatePublicWhiteIps API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatepublicwhiteips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdatePublicWhiteIpsWithCallback(request *UpdatePublicWhiteIpsRequest, callback func(response *UpdatePublicWhiteIpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePublicWhiteIpsResponse
		var err error
		defer close(result)
		response, err = client.UpdatePublicWhiteIps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePublicWhiteIpsRequest is the request struct for api UpdatePublicWhiteIps
type UpdatePublicWhiteIpsRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// UpdatePublicWhiteIpsResponse is the response struct for api UpdatePublicWhiteIps
type UpdatePublicWhiteIpsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateUpdatePublicWhiteIpsRequest creates a request to invoke UpdatePublicWhiteIps API
func CreateUpdatePublicWhiteIpsRequest() (request *UpdatePublicWhiteIpsRequest) {
	request = &UpdatePublicWhiteIpsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdatePublicWhiteIps", "/openapi/instances/[InstanceId]/public-white-ips", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePublicWhiteIpsResponse creates a response to parse from UpdatePublicWhiteIps response
func CreateUpdatePublicWhiteIpsResponse() (response *UpdatePublicWhiteIpsResponse) {
	response = &UpdatePublicWhiteIpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
