package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddClusterServiceForAdmin invokes the emr.AddClusterServiceForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/addclusterserviceforadmin.html
func (client *Client) AddClusterServiceForAdmin(request *AddClusterServiceForAdminRequest) (response *AddClusterServiceForAdminResponse, err error) {
	response = CreateAddClusterServiceForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// AddClusterServiceForAdminWithChan invokes the emr.AddClusterServiceForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/addclusterserviceforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddClusterServiceForAdminWithChan(request *AddClusterServiceForAdminRequest) (<-chan *AddClusterServiceForAdminResponse, <-chan error) {
	responseChan := make(chan *AddClusterServiceForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddClusterServiceForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddClusterServiceForAdminWithCallback invokes the emr.AddClusterServiceForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/addclusterserviceforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddClusterServiceForAdminWithCallback(request *AddClusterServiceForAdminRequest, callback func(response *AddClusterServiceForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddClusterServiceForAdminResponse
		var err error
		defer close(result)
		response, err = client.AddClusterServiceForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddClusterServiceForAdminRequest is the request struct for api AddClusterServiceForAdmin
type AddClusterServiceForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceList     string           `position:"Query" name:"ServiceList"`
	Comment         string           `position:"Query" name:"Comment"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// AddClusterServiceForAdminResponse is the response struct for api AddClusterServiceForAdmin
type AddClusterServiceForAdminResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddClusterServiceForAdminRequest creates a request to invoke AddClusterServiceForAdmin API
func CreateAddClusterServiceForAdminRequest() (request *AddClusterServiceForAdminRequest) {
	request = &AddClusterServiceForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AddClusterServiceForAdmin", "emr", "openAPI")
	return
}

// CreateAddClusterServiceForAdminResponse creates a response to parse from AddClusterServiceForAdmin response
func CreateAddClusterServiceForAdminResponse() (response *AddClusterServiceForAdminResponse) {
	response = &AddClusterServiceForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
