package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUserResourceRole invokes the emr.AddUserResourceRole API synchronously
// api document: https://help.aliyun.com/api/emr/adduserresourcerole.html
func (client *Client) AddUserResourceRole(request *AddUserResourceRoleRequest) (response *AddUserResourceRoleResponse, err error) {
	response = CreateAddUserResourceRoleResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserResourceRoleWithChan invokes the emr.AddUserResourceRole API asynchronously
// api document: https://help.aliyun.com/api/emr/adduserresourcerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddUserResourceRoleWithChan(request *AddUserResourceRoleRequest) (<-chan *AddUserResourceRoleResponse, <-chan error) {
	responseChan := make(chan *AddUserResourceRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUserResourceRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserResourceRoleWithCallback invokes the emr.AddUserResourceRole API asynchronously
// api document: https://help.aliyun.com/api/emr/adduserresourcerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddUserResourceRoleWithCallback(request *AddUserResourceRoleRequest, callback func(response *AddUserResourceRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserResourceRoleResponse
		var err error
		defer close(result)
		response, err = client.AddUserResourceRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserResourceRoleRequest is the request struct for api AddUserResourceRole
type AddUserResourceRoleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	RoleId          requests.Integer `position:"Query" name:"RoleId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
}

// AddUserResourceRoleResponse is the response struct for api AddUserResourceRole
type AddUserResourceRoleResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateAddUserResourceRoleRequest creates a request to invoke AddUserResourceRole API
func CreateAddUserResourceRoleRequest() (request *AddUserResourceRoleRequest) {
	request = &AddUserResourceRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AddUserResourceRole", "emr", "openAPI")
	return
}

// CreateAddUserResourceRoleResponse creates a response to parse from AddUserResourceRole response
func CreateAddUserResourceRoleResponse() (response *AddUserResourceRoleResponse) {
	response = &AddUserResourceRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
