package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNavNode invokes the emr.DeleteNavNode API synchronously
// api document: https://help.aliyun.com/api/emr/deletenavnode.html
func (client *Client) DeleteNavNode(request *DeleteNavNodeRequest) (response *DeleteNavNodeResponse, err error) {
	response = CreateDeleteNavNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNavNodeWithChan invokes the emr.DeleteNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/deletenavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNavNodeWithChan(request *DeleteNavNodeRequest) (<-chan *DeleteNavNodeResponse, <-chan error) {
	responseChan := make(chan *DeleteNavNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNavNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNavNodeWithCallback invokes the emr.DeleteNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/deletenavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNavNodeWithCallback(request *DeleteNavNodeRequest, callback func(response *DeleteNavNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNavNodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteNavNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNavNodeRequest is the request struct for api DeleteNavNode
type DeleteNavNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
}

// DeleteNavNodeResponse is the response struct for api DeleteNavNode
type DeleteNavNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNavNodeRequest creates a request to invoke DeleteNavNode API
func CreateDeleteNavNodeRequest() (request *DeleteNavNodeRequest) {
	request = &DeleteNavNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteNavNode", "emr", "openAPI")
	return
}

// CreateDeleteNavNodeResponse creates a response to parse from DeleteNavNode response
func CreateDeleteNavNodeResponse() (response *DeleteNavNodeResponse) {
	response = &DeleteNavNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
