package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterResourcePoolSchedulerTypeForAdmin invokes the emr.DescribeClusterResourcePoolSchedulerTypeForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusterresourcepoolschedulertypeforadmin.html
func (client *Client) DescribeClusterResourcePoolSchedulerTypeForAdmin(request *DescribeClusterResourcePoolSchedulerTypeForAdminRequest) (response *DescribeClusterResourcePoolSchedulerTypeForAdminResponse, err error) {
	response = CreateDescribeClusterResourcePoolSchedulerTypeForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterResourcePoolSchedulerTypeForAdminWithChan invokes the emr.DescribeClusterResourcePoolSchedulerTypeForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterresourcepoolschedulertypeforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterResourcePoolSchedulerTypeForAdminWithChan(request *DescribeClusterResourcePoolSchedulerTypeForAdminRequest) (<-chan *DescribeClusterResourcePoolSchedulerTypeForAdminResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterResourcePoolSchedulerTypeForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterResourcePoolSchedulerTypeForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterResourcePoolSchedulerTypeForAdminWithCallback invokes the emr.DescribeClusterResourcePoolSchedulerTypeForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterresourcepoolschedulertypeforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterResourcePoolSchedulerTypeForAdminWithCallback(request *DescribeClusterResourcePoolSchedulerTypeForAdminRequest, callback func(response *DescribeClusterResourcePoolSchedulerTypeForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterResourcePoolSchedulerTypeForAdminResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterResourcePoolSchedulerTypeForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterResourcePoolSchedulerTypeForAdminRequest is the request struct for api DescribeClusterResourcePoolSchedulerTypeForAdmin
type DescribeClusterResourcePoolSchedulerTypeForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// DescribeClusterResourcePoolSchedulerTypeForAdminResponse is the response struct for api DescribeClusterResourcePoolSchedulerTypeForAdmin
type DescribeClusterResourcePoolSchedulerTypeForAdminResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	CurrentSchedulerType string `json:"CurrentSchedulerType" xml:"CurrentSchedulerType"`
	SupportSchedulerType string `json:"SupportSchedulerType" xml:"SupportSchedulerType"`
	DefaultSchedulerType string `json:"DefaultSchedulerType" xml:"DefaultSchedulerType"`
}

// CreateDescribeClusterResourcePoolSchedulerTypeForAdminRequest creates a request to invoke DescribeClusterResourcePoolSchedulerTypeForAdmin API
func CreateDescribeClusterResourcePoolSchedulerTypeForAdminRequest() (request *DescribeClusterResourcePoolSchedulerTypeForAdminRequest) {
	request = &DescribeClusterResourcePoolSchedulerTypeForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterResourcePoolSchedulerTypeForAdmin", "emr", "openAPI")
	return
}

// CreateDescribeClusterResourcePoolSchedulerTypeForAdminResponse creates a response to parse from DescribeClusterResourcePoolSchedulerTypeForAdmin response
func CreateDescribeClusterResourcePoolSchedulerTypeForAdminResponse() (response *DescribeClusterResourcePoolSchedulerTypeForAdminResponse) {
	response = &DescribeClusterResourcePoolSchedulerTypeForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
