package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKafkaBroker invokes the emr.DescribeKafkaBroker API synchronously
// api document: https://help.aliyun.com/api/emr/describekafkabroker.html
func (client *Client) DescribeKafkaBroker(request *DescribeKafkaBrokerRequest) (response *DescribeKafkaBrokerResponse, err error) {
	response = CreateDescribeKafkaBrokerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKafkaBrokerWithChan invokes the emr.DescribeKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/describekafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKafkaBrokerWithChan(request *DescribeKafkaBrokerRequest) (<-chan *DescribeKafkaBrokerResponse, <-chan error) {
	responseChan := make(chan *DescribeKafkaBrokerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKafkaBroker(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKafkaBrokerWithCallback invokes the emr.DescribeKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/describekafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKafkaBrokerWithCallback(request *DescribeKafkaBrokerRequest, callback func(response *DescribeKafkaBrokerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKafkaBrokerResponse
		var err error
		defer close(result)
		response, err = client.DescribeKafkaBroker(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKafkaBrokerRequest is the request struct for api DescribeKafkaBroker
type DescribeKafkaBrokerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostId          string           `position:"Query" name:"HostId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DescribeKafkaBrokerResponse is the response struct for api DescribeKafkaBroker
type DescribeKafkaBrokerResponse struct {
	*responses.BaseResponse
	RequestId         string                         `json:"RequestId" xml:"RequestId"`
	BrokerId          int                            `json:"BrokerId" xml:"BrokerId"`
	HostId            string                         `json:"HostId" xml:"HostId"`
	HostName          string                         `json:"HostName" xml:"HostName"`
	HostIp            string                         `json:"HostIp" xml:"HostIp"`
	Status            string                         `json:"Status" xml:"Status"`
	PartitionCount    int                            `json:"PartitionCount" xml:"PartitionCount"`
	LeaderCount       int                            `json:"LeaderCount" xml:"LeaderCount"`
	TopicCount        int                            `json:"TopicCount" xml:"TopicCount"`
	DiskUnbalanceRate string                         `json:"DiskUnbalanceRate" xml:"DiskUnbalanceRate"`
	DiskUsageMean     string                         `json:"DiskUsageMean" xml:"DiskUsageMean"`
	DiskUsageMax      string                         `json:"DiskUsageMax" xml:"DiskUsageMax"`
	DiskCapacity      int                            `json:"DiskCapacity" xml:"DiskCapacity"`
	Traffic           string                         `json:"Traffic" xml:"Traffic"`
	TopicList         TopicListInDescribeKafkaBroker `json:"TopicList" xml:"TopicList"`
}

// CreateDescribeKafkaBrokerRequest creates a request to invoke DescribeKafkaBroker API
func CreateDescribeKafkaBrokerRequest() (request *DescribeKafkaBrokerRequest) {
	request = &DescribeKafkaBrokerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeKafkaBroker", "emr", "openAPI")
	return
}

// CreateDescribeKafkaBrokerResponse creates a response to parse from DescribeKafkaBroker response
func CreateDescribeKafkaBrokerResponse() (response *DescribeKafkaBrokerResponse) {
	response = &DescribeKafkaBrokerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
