package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWorkspaceRepoSetting invokes the emr.DescribeWorkspaceRepoSetting API synchronously
// api document: https://help.aliyun.com/api/emr/describeworkspacereposetting.html
func (client *Client) DescribeWorkspaceRepoSetting(request *DescribeWorkspaceRepoSettingRequest) (response *DescribeWorkspaceRepoSettingResponse, err error) {
	response = CreateDescribeWorkspaceRepoSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWorkspaceRepoSettingWithChan invokes the emr.DescribeWorkspaceRepoSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/describeworkspacereposetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWorkspaceRepoSettingWithChan(request *DescribeWorkspaceRepoSettingRequest) (<-chan *DescribeWorkspaceRepoSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeWorkspaceRepoSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWorkspaceRepoSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWorkspaceRepoSettingWithCallback invokes the emr.DescribeWorkspaceRepoSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/describeworkspacereposetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWorkspaceRepoSettingWithCallback(request *DescribeWorkspaceRepoSettingRequest, callback func(response *DescribeWorkspaceRepoSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWorkspaceRepoSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeWorkspaceRepoSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWorkspaceRepoSettingRequest is the request struct for api DescribeWorkspaceRepoSetting
type DescribeWorkspaceRepoSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	WorkspaceId     string           `position:"Query" name:"WorkspaceId"`
}

// DescribeWorkspaceRepoSettingResponse is the response struct for api DescribeWorkspaceRepoSetting
type DescribeWorkspaceRepoSettingResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	RepoMaven RepoMaven `json:"RepoMaven" xml:"RepoMaven"`
	RepoPip   RepoPip   `json:"RepoPip" xml:"RepoPip"`
}

// CreateDescribeWorkspaceRepoSettingRequest creates a request to invoke DescribeWorkspaceRepoSetting API
func CreateDescribeWorkspaceRepoSettingRequest() (request *DescribeWorkspaceRepoSettingRequest) {
	request = &DescribeWorkspaceRepoSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeWorkspaceRepoSetting", "emr", "openAPI")
	return
}

// CreateDescribeWorkspaceRepoSettingResponse creates a response to parse from DescribeWorkspaceRepoSetting response
func CreateDescribeWorkspaceRepoSettingResponse() (response *DescribeWorkspaceRepoSettingResponse) {
	response = &DescribeWorkspaceRepoSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
