package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetadataTypeList invokes the emr.GetMetadataTypeList API synchronously
// api document: https://help.aliyun.com/api/emr/getmetadatatypelist.html
func (client *Client) GetMetadataTypeList(request *GetMetadataTypeListRequest) (response *GetMetadataTypeListResponse, err error) {
	response = CreateGetMetadataTypeListResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetadataTypeListWithChan invokes the emr.GetMetadataTypeList API asynchronously
// api document: https://help.aliyun.com/api/emr/getmetadatatypelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMetadataTypeListWithChan(request *GetMetadataTypeListRequest) (<-chan *GetMetadataTypeListResponse, <-chan error) {
	responseChan := make(chan *GetMetadataTypeListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetadataTypeList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetadataTypeListWithCallback invokes the emr.GetMetadataTypeList API asynchronously
// api document: https://help.aliyun.com/api/emr/getmetadatatypelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMetadataTypeListWithCallback(request *GetMetadataTypeListRequest, callback func(response *GetMetadataTypeListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetadataTypeListResponse
		var err error
		defer close(result)
		response, err = client.GetMetadataTypeList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetadataTypeListRequest is the request struct for api GetMetadataTypeList
type GetMetadataTypeListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// GetMetadataTypeListResponse is the response struct for api GetMetadataTypeList
type GetMetadataTypeListResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Data      DataInGetMetadataTypeList `json:"Data" xml:"Data"`
}

// CreateGetMetadataTypeListRequest creates a request to invoke GetMetadataTypeList API
func CreateGetMetadataTypeListRequest() (request *GetMetadataTypeListRequest) {
	request = &GetMetadataTypeListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetMetadataTypeList", "emr", "openAPI")
	return
}

// CreateGetMetadataTypeListResponse creates a response to parse from GetMetadataTypeList response
func CreateGetMetadataTypeListResponse() (response *GetMetadataTypeListResponse) {
	response = &GetMetadataTypeListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
