package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBackupRules invokes the emr.ListBackupRules API synchronously
// api document: https://help.aliyun.com/api/emr/listbackuprules.html
func (client *Client) ListBackupRules(request *ListBackupRulesRequest) (response *ListBackupRulesResponse, err error) {
	response = CreateListBackupRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBackupRulesWithChan invokes the emr.ListBackupRules API asynchronously
// api document: https://help.aliyun.com/api/emr/listbackuprules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBackupRulesWithChan(request *ListBackupRulesRequest) (<-chan *ListBackupRulesResponse, <-chan error) {
	responseChan := make(chan *ListBackupRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBackupRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBackupRulesWithCallback invokes the emr.ListBackupRules API asynchronously
// api document: https://help.aliyun.com/api/emr/listbackuprules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBackupRulesWithCallback(request *ListBackupRulesRequest, callback func(response *ListBackupRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBackupRulesResponse
		var err error
		defer close(result)
		response, err = client.ListBackupRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBackupRulesRequest is the request struct for api ListBackupRules
type ListBackupRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	BackupPlanId    string           `position:"Query" name:"BackupPlanId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Id              requests.Integer `position:"Query" name:"Id"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
	BizId           string           `position:"Query" name:"BizId"`
	Status          string           `position:"Query" name:"Status"`
}

// ListBackupRulesResponse is the response struct for api ListBackupRules
type ListBackupRulesResponse struct {
	*responses.BaseResponse
	RequestId  string                 `json:"RequestId" xml:"RequestId"`
	PageNumber int                    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                    `json:"PageSize" xml:"PageSize"`
	TotalCount int                    `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInListBackupRules `json:"Items" xml:"Items"`
}

// CreateListBackupRulesRequest creates a request to invoke ListBackupRules API
func CreateListBackupRulesRequest() (request *ListBackupRulesRequest) {
	request = &ListBackupRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListBackupRules", "emr", "openAPI")
	return
}

// CreateListBackupRulesResponse creates a response to parse from ListBackupRules response
func CreateListBackupRulesResponse() (response *ListBackupRulesResponse) {
	response = &ListBackupRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
