package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterHostComponentForAdmin invokes the emr.ListClusterHostComponentForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponentforadmin.html
func (client *Client) ListClusterHostComponentForAdmin(request *ListClusterHostComponentForAdminRequest) (response *ListClusterHostComponentForAdminResponse, err error) {
	response = CreateListClusterHostComponentForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterHostComponentForAdminWithChan invokes the emr.ListClusterHostComponentForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponentforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterHostComponentForAdminWithChan(request *ListClusterHostComponentForAdminRequest) (<-chan *ListClusterHostComponentForAdminResponse, <-chan error) {
	responseChan := make(chan *ListClusterHostComponentForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterHostComponentForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterHostComponentForAdminWithCallback invokes the emr.ListClusterHostComponentForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponentforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterHostComponentForAdminWithCallback(request *ListClusterHostComponentForAdminRequest, callback func(response *ListClusterHostComponentForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterHostComponentForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListClusterHostComponentForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterHostComponentForAdminRequest is the request struct for api ListClusterHostComponentForAdmin
type ListClusterHostComponentForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostInstanceId  string           `position:"Query" name:"HostInstanceId"`
	ComponentName   string           `position:"Query" name:"ComponentName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ComponentStatus string           `position:"Query" name:"ComponentStatus"`
	HostName        string           `position:"Query" name:"HostName"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	HostRole        string           `position:"Query" name:"HostRole"`
}

// ListClusterHostComponentForAdminResponse is the response struct for api ListClusterHostComponentForAdmin
type ListClusterHostComponentForAdminResponse struct {
	*responses.BaseResponse
	RequestId     string                                          `json:"RequestId" xml:"RequestId"`
	PageNumber    int                                             `json:"PageNumber" xml:"PageNumber"`
	PageSize      int                                             `json:"PageSize" xml:"PageSize"`
	Total         int                                             `json:"Total" xml:"Total"`
	ComponentList ComponentListInListClusterHostComponentForAdmin `json:"ComponentList" xml:"ComponentList"`
}

// CreateListClusterHostComponentForAdminRequest creates a request to invoke ListClusterHostComponentForAdmin API
func CreateListClusterHostComponentForAdminRequest() (request *ListClusterHostComponentForAdminRequest) {
	request = &ListClusterHostComponentForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterHostComponentForAdmin", "emr", "openAPI")
	return
}

// CreateListClusterHostComponentForAdminResponse creates a response to parse from ListClusterHostComponentForAdmin response
func CreateListClusterHostComponentForAdminResponse() (response *ListClusterHostComponentForAdminResponse) {
	response = &ListClusterHostComponentForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
