package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterTag invokes the emr.ListClusterTag API synchronously
// api document: https://help.aliyun.com/api/emr/listclustertag.html
func (client *Client) ListClusterTag(request *ListClusterTagRequest) (response *ListClusterTagResponse, err error) {
	response = CreateListClusterTagResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterTagWithChan invokes the emr.ListClusterTag API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustertag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTagWithChan(request *ListClusterTagRequest) (<-chan *ListClusterTagResponse, <-chan error) {
	responseChan := make(chan *ListClusterTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterTagWithCallback invokes the emr.ListClusterTag API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustertag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTagWithCallback(request *ListClusterTagRequest, callback func(response *ListClusterTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterTagResponse
		var err error
		defer close(result)
		response, err = client.ListClusterTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterTagRequest is the request struct for api ListClusterTag
type ListClusterTagRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterIdList   *[]string        `position:"Query" name:"ClusterIdList"  type:"Repeated"`
}

// ListClusterTagResponse is the response struct for api ListClusterTag
type ListClusterTagResponse struct {
	*responses.BaseResponse
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	ClusterTagList ClusterTagListInListClusterTag `json:"ClusterTagList" xml:"ClusterTagList"`
}

// CreateListClusterTagRequest creates a request to invoke ListClusterTag API
func CreateListClusterTagRequest() (request *ListClusterTagRequest) {
	request = &ListClusterTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterTag", "emr", "openAPI")
	return
}

// CreateListClusterTagResponse creates a response to parse from ListClusterTag response
func CreateListClusterTagResponse() (response *ListClusterTagResponse) {
	response = &ListClusterTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
