package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterTagForAdmin invokes the emr.ListClusterTagForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listclustertagforadmin.html
func (client *Client) ListClusterTagForAdmin(request *ListClusterTagForAdminRequest) (response *ListClusterTagForAdminResponse, err error) {
	response = CreateListClusterTagForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterTagForAdminWithChan invokes the emr.ListClusterTagForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustertagforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTagForAdminWithChan(request *ListClusterTagForAdminRequest) (<-chan *ListClusterTagForAdminResponse, <-chan error) {
	responseChan := make(chan *ListClusterTagForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterTagForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterTagForAdminWithCallback invokes the emr.ListClusterTagForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustertagforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTagForAdminWithCallback(request *ListClusterTagForAdminRequest, callback func(response *ListClusterTagForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterTagForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListClusterTagForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterTagForAdminRequest is the request struct for api ListClusterTagForAdmin
type ListClusterTagForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterIdList   *[]string        `position:"Query" name:"ClusterIdList"  type:"Repeated"`
	UserId          string           `position:"Query" name:"UserId"`
}

// ListClusterTagForAdminResponse is the response struct for api ListClusterTagForAdmin
type ListClusterTagForAdminResponse struct {
	*responses.BaseResponse
	RequestId      string                                 `json:"RequestId" xml:"RequestId"`
	ClusterTagList ClusterTagListInListClusterTagForAdmin `json:"ClusterTagList" xml:"ClusterTagList"`
}

// CreateListClusterTagForAdminRequest creates a request to invoke ListClusterTagForAdmin API
func CreateListClusterTagForAdminRequest() (request *ListClusterTagForAdminRequest) {
	request = &ListClusterTagForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterTagForAdmin", "emr", "openAPI")
	return
}

// CreateListClusterTagForAdminResponse creates a response to parse from ListClusterTagForAdmin response
func CreateListClusterTagForAdminResponse() (response *ListClusterTagForAdminResponse) {
	response = &ListClusterTagForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
