package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlow invokes the emr.ListFlow API synchronously
// api document: https://help.aliyun.com/api/emr/listflow.html
func (client *Client) ListFlow(request *ListFlowRequest) (response *ListFlowResponse, err error) {
	response = CreateListFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowWithChan invokes the emr.ListFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/listflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowWithChan(request *ListFlowRequest) (<-chan *ListFlowResponse, <-chan error) {
	responseChan := make(chan *ListFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowWithCallback invokes the emr.ListFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/listflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowWithCallback(request *ListFlowRequest, callback func(response *ListFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowResponse
		var err error
		defer close(result)
		response, err = client.ListFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowRequest is the request struct for api ListFlow
type ListFlowRequest struct {
	*requests.RpcRequest
	JobId      string           `position:"Query" name:"JobId"`
	Periodic   requests.Boolean `position:"Query" name:"Periodic"`
	Name       string           `position:"Query" name:"Name"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Id         string           `position:"Query" name:"Id"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
	ProjectId  string           `position:"Query" name:"ProjectId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Status     string           `position:"Query" name:"Status"`
}

// ListFlowResponse is the response struct for api ListFlow
type ListFlowResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	Total      int    `json:"Total" xml:"Total"`
	Flow       Flow   `json:"Flow" xml:"Flow"`
}

// CreateListFlowRequest creates a request to invoke ListFlow API
func CreateListFlowRequest() (request *ListFlowRequest) {
	request = &ListFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlow", "emr", "openAPI")
	return
}

// CreateListFlowResponse creates a response to parse from ListFlow response
func CreateListFlowResponse() (response *ListFlowResponse) {
	response = &ListFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
