package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHostPool invokes the emr.ListHostPool API synchronously
// api document: https://help.aliyun.com/api/emr/listhostpool.html
func (client *Client) ListHostPool(request *ListHostPoolRequest) (response *ListHostPoolResponse, err error) {
	response = CreateListHostPoolResponse()
	err = client.DoAction(request, response)
	return
}

// ListHostPoolWithChan invokes the emr.ListHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/listhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListHostPoolWithChan(request *ListHostPoolRequest) (<-chan *ListHostPoolResponse, <-chan error) {
	responseChan := make(chan *ListHostPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHostPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHostPoolWithCallback invokes the emr.ListHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/listhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListHostPoolWithCallback(request *ListHostPoolRequest, callback func(response *ListHostPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHostPoolResponse
		var err error
		defer close(result)
		response, err = client.ListHostPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHostPoolRequest is the request struct for api ListHostPool
type ListHostPoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListHostPoolResponse is the response struct for api ListHostPool
type ListHostPoolResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	HostPoolList HostPoolList `json:"HostPoolList" xml:"HostPoolList"`
}

// CreateListHostPoolRequest creates a request to invoke ListHostPool API
func CreateListHostPoolRequest() (request *ListHostPoolRequest) {
	request = &ListHostPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListHostPool", "emr", "openAPI")
	return
}

// CreateListHostPoolResponse creates a response to parse from ListHostPool response
func CreateListHostPoolResponse() (response *ListHostPoolResponse) {
	response = &ListHostPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
