package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListKafkaBroker invokes the emr.ListKafkaBroker API synchronously
// api document: https://help.aliyun.com/api/emr/listkafkabroker.html
func (client *Client) ListKafkaBroker(request *ListKafkaBrokerRequest) (response *ListKafkaBrokerResponse, err error) {
	response = CreateListKafkaBrokerResponse()
	err = client.DoAction(request, response)
	return
}

// ListKafkaBrokerWithChan invokes the emr.ListKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaBrokerWithChan(request *ListKafkaBrokerRequest) (<-chan *ListKafkaBrokerResponse, <-chan error) {
	responseChan := make(chan *ListKafkaBrokerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListKafkaBroker(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListKafkaBrokerWithCallback invokes the emr.ListKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaBrokerWithCallback(request *ListKafkaBrokerRequest, callback func(response *ListKafkaBrokerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListKafkaBrokerResponse
		var err error
		defer close(result)
		response, err = client.ListKafkaBroker(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListKafkaBrokerRequest is the request struct for api ListKafkaBroker
type ListKafkaBrokerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListKafkaBrokerResponse is the response struct for api ListKafkaBroker
type ListKafkaBrokerResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Total      int        `json:"Total" xml:"Total"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	BrokerList BrokerList `json:"BrokerList" xml:"BrokerList"`
}

// CreateListKafkaBrokerRequest creates a request to invoke ListKafkaBroker API
func CreateListKafkaBrokerRequest() (request *ListKafkaBrokerRequest) {
	request = &ListKafkaBrokerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListKafkaBroker", "emr", "openAPI")
	return
}

// CreateListKafkaBrokerResponse creates a response to parse from ListKafkaBroker response
func CreateListKafkaBrokerResponse() (response *ListKafkaBrokerResponse) {
	response = &ListKafkaBrokerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
