package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListKafkaReassign invokes the emr.ListKafkaReassign API synchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassign.html
func (client *Client) ListKafkaReassign(request *ListKafkaReassignRequest) (response *ListKafkaReassignResponse, err error) {
	response = CreateListKafkaReassignResponse()
	err = client.DoAction(request, response)
	return
}

// ListKafkaReassignWithChan invokes the emr.ListKafkaReassign API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaReassignWithChan(request *ListKafkaReassignRequest) (<-chan *ListKafkaReassignResponse, <-chan error) {
	responseChan := make(chan *ListKafkaReassignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListKafkaReassign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListKafkaReassignWithCallback invokes the emr.ListKafkaReassign API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaReassignWithCallback(request *ListKafkaReassignRequest, callback func(response *ListKafkaReassignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListKafkaReassignResponse
		var err error
		defer close(result)
		response, err = client.ListKafkaReassign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListKafkaReassignRequest is the request struct for api ListKafkaReassign
type ListKafkaReassignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListKafkaReassignResponse is the response struct for api ListKafkaReassign
type ListKafkaReassignResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Total        int          `json:"Total" xml:"Total"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	ReassignList ReassignList `json:"ReassignList" xml:"ReassignList"`
}

// CreateListKafkaReassignRequest creates a request to invoke ListKafkaReassign API
func CreateListKafkaReassignRequest() (request *ListKafkaReassignRequest) {
	request = &ListKafkaReassignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListKafkaReassign", "emr", "openAPI")
	return
}

// CreateListKafkaReassignResponse creates a response to parse from ListKafkaReassign response
func CreateListKafkaReassignResponse() (response *ListKafkaReassignResponse) {
	response = &ListKafkaReassignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
