package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUsersByCondition invokes the emr.ListUsersByCondition API synchronously
// api document: https://help.aliyun.com/api/emr/listusersbycondition.html
func (client *Client) ListUsersByCondition(request *ListUsersByConditionRequest) (response *ListUsersByConditionResponse, err error) {
	response = CreateListUsersByConditionResponse()
	err = client.DoAction(request, response)
	return
}

// ListUsersByConditionWithChan invokes the emr.ListUsersByCondition API asynchronously
// api document: https://help.aliyun.com/api/emr/listusersbycondition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUsersByConditionWithChan(request *ListUsersByConditionRequest) (<-chan *ListUsersByConditionResponse, <-chan error) {
	responseChan := make(chan *ListUsersByConditionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUsersByCondition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUsersByConditionWithCallback invokes the emr.ListUsersByCondition API asynchronously
// api document: https://help.aliyun.com/api/emr/listusersbycondition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUsersByConditionWithCallback(request *ListUsersByConditionRequest, callback func(response *ListUsersByConditionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUsersByConditionResponse
		var err error
		defer close(result)
		response, err = client.ListUsersByCondition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUsersByConditionRequest is the request struct for api ListUsersByCondition
type ListUsersByConditionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SearchKey       string           `position:"Query" name:"SearchKey"`
}

// ListUsersByConditionResponse is the response struct for api ListUsersByCondition
type ListUsersByConditionResponse struct {
	*responses.BaseResponse
	Paging    bool                       `json:"Paging" xml:"Paging"`
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Data      DataInListUsersByCondition `json:"Data" xml:"Data"`
}

// CreateListUsersByConditionRequest creates a request to invoke ListUsersByCondition API
func CreateListUsersByConditionRequest() (request *ListUsersByConditionRequest) {
	request = &ListUsersByConditionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListUsersByCondition", "emr", "openAPI")
	return
}

// CreateListUsersByConditionResponse creates a response to parse from ListUsersByCondition response
func CreateListUsersByConditionResponse() (response *ListUsersByConditionResponse) {
	response = &ListUsersByConditionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
