package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDescribeKafkaTopic invokes the emr.MetastoreDescribeKafkaTopic API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribekafkatopic.html
func (client *Client) MetastoreDescribeKafkaTopic(request *MetastoreDescribeKafkaTopicRequest) (response *MetastoreDescribeKafkaTopicResponse, err error) {
	response = CreateMetastoreDescribeKafkaTopicResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDescribeKafkaTopicWithChan invokes the emr.MetastoreDescribeKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeKafkaTopicWithChan(request *MetastoreDescribeKafkaTopicRequest) (<-chan *MetastoreDescribeKafkaTopicResponse, <-chan error) {
	responseChan := make(chan *MetastoreDescribeKafkaTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDescribeKafkaTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDescribeKafkaTopicWithCallback invokes the emr.MetastoreDescribeKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeKafkaTopicWithCallback(request *MetastoreDescribeKafkaTopicRequest, callback func(response *MetastoreDescribeKafkaTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDescribeKafkaTopicResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDescribeKafkaTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDescribeKafkaTopicRequest is the request struct for api MetastoreDescribeKafkaTopic
type MetastoreDescribeKafkaTopicRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
}

// MetastoreDescribeKafkaTopicResponse is the response struct for api MetastoreDescribeKafkaTopic
type MetastoreDescribeKafkaTopicResponse struct {
	*responses.BaseResponse
	RequestId                   string                                          `json:"RequestId" xml:"RequestId"`
	Id                          string                                          `json:"Id" xml:"Id"`
	DataSourceId                string                                          `json:"DataSourceId" xml:"DataSourceId"`
	TopicName                   string                                          `json:"TopicName" xml:"TopicName"`
	NumPartitions               int                                             `json:"NumPartitions" xml:"NumPartitions"`
	ReplicationFactor           int                                             `json:"ReplicationFactor" xml:"ReplicationFactor"`
	GmtCreate                   int64                                           `json:"GmtCreate" xml:"GmtCreate"`
	GmtModified                 int64                                           `json:"GmtModified" xml:"GmtModified"`
	BrokerTotal                 int                                             `json:"BrokerTotal" xml:"BrokerTotal"`
	NumUsingBrokers             int                                             `json:"NumUsingBrokers" xml:"NumUsingBrokers"`
	BrokersLeaderSkewPercentage string                                          `json:"BrokersLeaderSkewPercentage" xml:"BrokersLeaderSkewPercentage"`
	UnderReplicatedPercentage   string                                          `json:"UnderReplicatedPercentage" xml:"UnderReplicatedPercentage"`
	PreferredReplicasPercentage string                                          `json:"PreferredReplicasPercentage" xml:"PreferredReplicasPercentage"`
	Status                      string                                          `json:"Status" xml:"Status"`
	ReassignId                  string                                          `json:"ReassignId" xml:"ReassignId"`
	Cluster                     Cluster                                         `json:"Cluster" xml:"Cluster"`
	AdvancedConfigList          AdvancedConfigListInMetastoreDescribeKafkaTopic `json:"AdvancedConfigList" xml:"AdvancedConfigList"`
	SummaryList                 SummaryList                                     `json:"SummaryList" xml:"SummaryList"`
	DistributionList            DistributionList                                `json:"DistributionList" xml:"DistributionList"`
}

// CreateMetastoreDescribeKafkaTopicRequest creates a request to invoke MetastoreDescribeKafkaTopic API
func CreateMetastoreDescribeKafkaTopicRequest() (request *MetastoreDescribeKafkaTopicRequest) {
	request = &MetastoreDescribeKafkaTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDescribeKafkaTopic", "emr", "openAPI")
	return
}

// CreateMetastoreDescribeKafkaTopicResponse creates a response to parse from MetastoreDescribeKafkaTopic response
func CreateMetastoreDescribeKafkaTopicResponse() (response *MetastoreDescribeKafkaTopicResponse) {
	response = &MetastoreDescribeKafkaTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
