package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClusterServiceConfig invokes the emr.ModifyClusterServiceConfig API synchronously
// api document: https://help.aliyun.com/api/emr/modifyclusterserviceconfig.html
func (client *Client) ModifyClusterServiceConfig(request *ModifyClusterServiceConfigRequest) (response *ModifyClusterServiceConfigResponse, err error) {
	response = CreateModifyClusterServiceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterServiceConfigWithChan invokes the emr.ModifyClusterServiceConfig API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyclusterserviceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyClusterServiceConfigWithChan(request *ModifyClusterServiceConfigRequest) (<-chan *ModifyClusterServiceConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterServiceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClusterServiceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterServiceConfigWithCallback invokes the emr.ModifyClusterServiceConfig API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyclusterserviceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyClusterServiceConfigWithCallback(request *ModifyClusterServiceConfigRequest, callback func(response *ModifyClusterServiceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterServiceConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyClusterServiceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterServiceConfigRequest is the request struct for api ModifyClusterServiceConfig
type ModifyClusterServiceConfigRequest struct {
	*requests.RpcRequest
	RefreshHostConfig    requests.Boolean `position:"Query" name:"RefreshHostConfig"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ConfigType           string           `position:"Query" name:"ConfigType"`
	HostInstanceId       string           `position:"Query" name:"HostInstanceId"`
	GroupId              string           `position:"Query" name:"GroupId"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	CustomConfigParams   string           `position:"Query" name:"CustomConfigParams"`
	ServiceName          string           `position:"Query" name:"ServiceName"`
	Comment              string           `position:"Query" name:"Comment"`
	GatewayClusterIdList *[]string        `position:"Query" name:"GatewayClusterIdList"  type:"Repeated"`
	ConfigParams         string           `position:"Query" name:"ConfigParams"`
}

// ModifyClusterServiceConfigResponse is the response struct for api ModifyClusterServiceConfig
type ModifyClusterServiceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClusterServiceConfigRequest creates a request to invoke ModifyClusterServiceConfig API
func CreateModifyClusterServiceConfigRequest() (request *ModifyClusterServiceConfigRequest) {
	request = &ModifyClusterServiceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyClusterServiceConfig", "emr", "openAPI")
	return
}

// CreateModifyClusterServiceConfigResponse creates a response to parse from ModifyClusterServiceConfig response
func CreateModifyClusterServiceConfigResponse() (response *ModifyClusterServiceConfigResponse) {
	response = &ModifyClusterServiceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
