package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageListUsers invokes the emr.PageListUsers API synchronously
// api document: https://help.aliyun.com/api/emr/pagelistusers.html
func (client *Client) PageListUsers(request *PageListUsersRequest) (response *PageListUsersResponse, err error) {
	response = CreatePageListUsersResponse()
	err = client.DoAction(request, response)
	return
}

// PageListUsersWithChan invokes the emr.PageListUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListUsersWithChan(request *PageListUsersRequest) (<-chan *PageListUsersResponse, <-chan error) {
	responseChan := make(chan *PageListUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageListUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageListUsersWithCallback invokes the emr.PageListUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListUsersWithCallback(request *PageListUsersRequest, callback func(response *PageListUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageListUsersResponse
		var err error
		defer close(result)
		response, err = client.PageListUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageListUsersRequest is the request struct for api PageListUsers
type PageListUsersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FuzzyName       string           `position:"Query" name:"FuzzyName"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// PageListUsersResponse is the response struct for api PageListUsers
type PageListUsersResponse struct {
	*responses.BaseResponse
	Paging     bool                 `json:"Paging" xml:"Paging"`
	RequestId  string               `json:"RequestId" xml:"RequestId"`
	PageNumber int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                  `json:"PageSize" xml:"PageSize"`
	TotalCount int                  `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInPageListUsers `json:"Items" xml:"Items"`
}

// CreatePageListUsersRequest creates a request to invoke PageListUsers API
func CreatePageListUsersRequest() (request *PageListUsersRequest) {
	request = &PageListUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "PageListUsers", "emr", "openAPI")
	return
}

// CreatePageListUsersResponse creates a response to parse from PageListUsers response
func CreatePageListUsersResponse() (response *PageListUsersResponse) {
	response = &PageListUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
