package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseETLJob invokes the emr.ReleaseETLJob API synchronously
// api document: https://help.aliyun.com/api/emr/releaseetljob.html
func (client *Client) ReleaseETLJob(request *ReleaseETLJobRequest) (response *ReleaseETLJobResponse, err error) {
	response = CreateReleaseETLJobResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseETLJobWithChan invokes the emr.ReleaseETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/releaseetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReleaseETLJobWithChan(request *ReleaseETLJobRequest) (<-chan *ReleaseETLJobResponse, <-chan error) {
	responseChan := make(chan *ReleaseETLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseETLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseETLJobWithCallback invokes the emr.ReleaseETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/releaseetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReleaseETLJobWithCallback(request *ReleaseETLJobRequest, callback func(response *ReleaseETLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseETLJobResponse
		var err error
		defer close(result)
		response, err = client.ReleaseETLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseETLJobRequest is the request struct for api ReleaseETLJob
type ReleaseETLJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReleaseId       string           `position:"Query" name:"ReleaseId"`
	Id              string           `position:"Query" name:"Id"`
}

// ReleaseETLJobResponse is the response struct for api ReleaseETLJob
type ReleaseETLJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ReleaseId string `json:"ReleaseId" xml:"ReleaseId"`
}

// CreateReleaseETLJobRequest creates a request to invoke ReleaseETLJob API
func CreateReleaseETLJobRequest() (request *ReleaseETLJobRequest) {
	request = &ReleaseETLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ReleaseETLJob", "emr", "openAPI")
	return
}

// CreateReleaseETLJobResponse creates a response to parse from ReleaseETLJob response
func CreateReleaseETLJobResponse() (response *ReleaseETLJobResponse) {
	response = &ReleaseETLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
