package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetrySyncUserAccount invokes the emr.RetrySyncUserAccount API synchronously
// api document: https://help.aliyun.com/api/emr/retrysyncuseraccount.html
func (client *Client) RetrySyncUserAccount(request *RetrySyncUserAccountRequest) (response *RetrySyncUserAccountResponse, err error) {
	response = CreateRetrySyncUserAccountResponse()
	err = client.DoAction(request, response)
	return
}

// RetrySyncUserAccountWithChan invokes the emr.RetrySyncUserAccount API asynchronously
// api document: https://help.aliyun.com/api/emr/retrysyncuseraccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetrySyncUserAccountWithChan(request *RetrySyncUserAccountRequest) (<-chan *RetrySyncUserAccountResponse, <-chan error) {
	responseChan := make(chan *RetrySyncUserAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetrySyncUserAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetrySyncUserAccountWithCallback invokes the emr.RetrySyncUserAccount API asynchronously
// api document: https://help.aliyun.com/api/emr/retrysyncuseraccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetrySyncUserAccountWithCallback(request *RetrySyncUserAccountRequest, callback func(response *RetrySyncUserAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetrySyncUserAccountResponse
		var err error
		defer close(result)
		response, err = client.RetrySyncUserAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetrySyncUserAccountRequest is the request struct for api RetrySyncUserAccount
type RetrySyncUserAccountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId       string           `position:"Query" name:"ResourceId"`
	AliyunUserIdList *[]string        `position:"Query" name:"AliyunUserIdList"  type:"Repeated"`
	AccountType      string           `position:"Query" name:"AccountType"`
	ResourceType     string           `position:"Query" name:"ResourceType"`
}

// RetrySyncUserAccountResponse is the response struct for api RetrySyncUserAccount
type RetrySyncUserAccountResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateRetrySyncUserAccountRequest creates a request to invoke RetrySyncUserAccount API
func CreateRetrySyncUserAccountRequest() (request *RetrySyncUserAccountRequest) {
	request = &RetrySyncUserAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RetrySyncUserAccount", "emr", "openAPI")
	return
}

// CreateRetrySyncUserAccountResponse creates a response to parse from RetrySyncUserAccount response
func CreateRetrySyncUserAccountResponse() (response *RetrySyncUserAccountResponse) {
	response = &RetrySyncUserAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
