package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWorkspaceRepoSetting invokes the emr.UpdateWorkspaceRepoSetting API synchronously
// api document: https://help.aliyun.com/api/emr/updateworkspacereposetting.html
func (client *Client) UpdateWorkspaceRepoSetting(request *UpdateWorkspaceRepoSettingRequest) (response *UpdateWorkspaceRepoSettingResponse, err error) {
	response = CreateUpdateWorkspaceRepoSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWorkspaceRepoSettingWithChan invokes the emr.UpdateWorkspaceRepoSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/updateworkspacereposetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkspaceRepoSettingWithChan(request *UpdateWorkspaceRepoSettingRequest) (<-chan *UpdateWorkspaceRepoSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateWorkspaceRepoSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWorkspaceRepoSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWorkspaceRepoSettingWithCallback invokes the emr.UpdateWorkspaceRepoSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/updateworkspacereposetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkspaceRepoSettingWithCallback(request *UpdateWorkspaceRepoSettingRequest, callback func(response *UpdateWorkspaceRepoSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWorkspaceRepoSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateWorkspaceRepoSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWorkspaceRepoSettingRequest is the request struct for api UpdateWorkspaceRepoSetting
type UpdateWorkspaceRepoSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                       `position:"Query" name:"ResourceOwnerId"`
	RepoMaven       *[]UpdateWorkspaceRepoSettingRepoMaven `position:"Query" name:"RepoMaven"  type:"Repeated"`
	RepoPip         *[]UpdateWorkspaceRepoSettingRepoPip   `position:"Query" name:"RepoPip"  type:"Repeated"`
	WorkspaceId     string                                 `position:"Query" name:"WorkspaceId"`
}

// UpdateWorkspaceRepoSettingRepoMaven is a repeated param struct in UpdateWorkspaceRepoSettingRequest
type UpdateWorkspaceRepoSettingRepoMaven struct {
	GroupId    string `name:"GroupId"`
	ArtifactId string `name:"ArtifactId"`
	Version    string `name:"Version"`
}

// UpdateWorkspaceRepoSettingRepoPip is a repeated param struct in UpdateWorkspaceRepoSettingRequest
type UpdateWorkspaceRepoSettingRepoPip struct {
	PackageName string `name:"PackageName"`
	Version     string `name:"Version"`
}

// UpdateWorkspaceRepoSettingResponse is the response struct for api UpdateWorkspaceRepoSetting
type UpdateWorkspaceRepoSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateWorkspaceRepoSettingRequest creates a request to invoke UpdateWorkspaceRepoSetting API
func CreateUpdateWorkspaceRepoSettingRequest() (request *UpdateWorkspaceRepoSettingRequest) {
	request = &UpdateWorkspaceRepoSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateWorkspaceRepoSetting", "emr", "openAPI")
	return
}

// CreateUpdateWorkspaceRepoSettingResponse creates a response to parse from UpdateWorkspaceRepoSetting response
func CreateUpdateWorkspaceRepoSettingResponse() (response *UpdateWorkspaceRepoSettingResponse) {
	response = &UpdateWorkspaceRepoSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
