package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceVertexTaskManagers invokes the foas.GetInstanceVertexTaskManagers API synchronously
// api document: https://help.aliyun.com/api/foas/getinstancevertextaskmanagers.html
func (client *Client) GetInstanceVertexTaskManagers(request *GetInstanceVertexTaskManagersRequest) (response *GetInstanceVertexTaskManagersResponse, err error) {
	response = CreateGetInstanceVertexTaskManagersResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceVertexTaskManagersWithChan invokes the foas.GetInstanceVertexTaskManagers API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancevertextaskmanagers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceVertexTaskManagersWithChan(request *GetInstanceVertexTaskManagersRequest) (<-chan *GetInstanceVertexTaskManagersResponse, <-chan error) {
	responseChan := make(chan *GetInstanceVertexTaskManagersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceVertexTaskManagers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceVertexTaskManagersWithCallback invokes the foas.GetInstanceVertexTaskManagers API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancevertextaskmanagers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceVertexTaskManagersWithCallback(request *GetInstanceVertexTaskManagersRequest, callback func(response *GetInstanceVertexTaskManagersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceVertexTaskManagersResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceVertexTaskManagers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceVertexTaskManagersRequest is the request struct for api GetInstanceVertexTaskManagers
type GetInstanceVertexTaskManagersRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	InstanceId  requests.Integer `position:"Path" name:"instanceId"`
	VertexId    string           `position:"Path" name:"vertexId"`
	JobName     string           `position:"Path" name:"jobName"`
}

// GetInstanceVertexTaskManagersResponse is the response struct for api GetInstanceVertexTaskManagers
type GetInstanceVertexTaskManagersResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	TaskManagers string `json:"TaskManagers" xml:"TaskManagers"`
}

// CreateGetInstanceVertexTaskManagersRequest creates a request to invoke GetInstanceVertexTaskManagers API
func CreateGetInstanceVertexTaskManagersRequest() (request *GetInstanceVertexTaskManagersRequest) {
	request = &GetInstanceVertexTaskManagersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetInstanceVertexTaskManagers", "/api/v2/projects/[projectName]/jobs/[jobName]/instances/[instanceId]/vertices/[vertexId]/taskmanagers", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetInstanceVertexTaskManagersResponse creates a response to parse from GetInstanceVertexTaskManagers response
func CreateGetInstanceVertexTaskManagersResponse() (response *GetInstanceVertexTaskManagersResponse) {
	response = &GetInstanceVertexTaskManagersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
