package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectBindQueueResource invokes the foas.ListProjectBindQueueResource API synchronously
// api document: https://help.aliyun.com/api/foas/listprojectbindqueueresource.html
func (client *Client) ListProjectBindQueueResource(request *ListProjectBindQueueResourceRequest) (response *ListProjectBindQueueResourceResponse, err error) {
	response = CreateListProjectBindQueueResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectBindQueueResourceWithChan invokes the foas.ListProjectBindQueueResource API asynchronously
// api document: https://help.aliyun.com/api/foas/listprojectbindqueueresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListProjectBindQueueResourceWithChan(request *ListProjectBindQueueResourceRequest) (<-chan *ListProjectBindQueueResourceResponse, <-chan error) {
	responseChan := make(chan *ListProjectBindQueueResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectBindQueueResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectBindQueueResourceWithCallback invokes the foas.ListProjectBindQueueResource API asynchronously
// api document: https://help.aliyun.com/api/foas/listprojectbindqueueresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListProjectBindQueueResourceWithCallback(request *ListProjectBindQueueResourceRequest, callback func(response *ListProjectBindQueueResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectBindQueueResourceResponse
		var err error
		defer close(result)
		response, err = client.ListProjectBindQueueResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectBindQueueResourceRequest is the request struct for api ListProjectBindQueueResource
type ListProjectBindQueueResourceRequest struct {
	*requests.RoaRequest
	QueueName   string `position:"Query" name:"queueName"`
	ProjectName string `position:"Path" name:"projectName"`
	ClusterId   string `position:"Query" name:"clusterId"`
}

// ListProjectBindQueueResourceResponse is the response struct for api ListProjectBindQueueResource
type ListProjectBindQueueResourceResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	Queues    QueuesInListProjectBindQueueResource `json:"Queues" xml:"Queues"`
}

// CreateListProjectBindQueueResourceRequest creates a request to invoke ListProjectBindQueueResource API
func CreateListProjectBindQueueResourceRequest() (request *ListProjectBindQueueResourceRequest) {
	request = &ListProjectBindQueueResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ListProjectBindQueueResource", "/api/v2/projects/[projectName]/queueresource", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListProjectBindQueueResourceResponse creates a response to parse from ListProjectBindQueueResource response
func CreateListProjectBindQueueResourceResponse() (response *ListProjectBindQueueResourceResponse) {
	response = &ListProjectBindQueueResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
