package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNotificationContacts invokes the green.DeleteNotificationContacts API synchronously
// api document: https://help.aliyun.com/api/green/deletenotificationcontacts.html
func (client *Client) DeleteNotificationContacts(request *DeleteNotificationContactsRequest) (response *DeleteNotificationContactsResponse, err error) {
	response = CreateDeleteNotificationContactsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNotificationContactsWithChan invokes the green.DeleteNotificationContacts API asynchronously
// api document: https://help.aliyun.com/api/green/deletenotificationcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNotificationContactsWithChan(request *DeleteNotificationContactsRequest) (<-chan *DeleteNotificationContactsResponse, <-chan error) {
	responseChan := make(chan *DeleteNotificationContactsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNotificationContacts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNotificationContactsWithCallback invokes the green.DeleteNotificationContacts API asynchronously
// api document: https://help.aliyun.com/api/green/deletenotificationcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNotificationContactsWithCallback(request *DeleteNotificationContactsRequest, callback func(response *DeleteNotificationContactsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNotificationContactsResponse
		var err error
		defer close(result)
		response, err = client.DeleteNotificationContacts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNotificationContactsRequest is the request struct for api DeleteNotificationContacts
type DeleteNotificationContactsRequest struct {
	*requests.RpcRequest
	ContactTypes string `position:"Query" name:"ContactTypes"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteNotificationContactsResponse is the response struct for api DeleteNotificationContacts
type DeleteNotificationContactsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNotificationContactsRequest creates a request to invoke DeleteNotificationContacts API
func CreateDeleteNotificationContactsRequest() (request *DeleteNotificationContactsRequest) {
	request = &DeleteNotificationContactsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DeleteNotificationContacts", "green", "openAPI")
	return
}

// CreateDeleteNotificationContactsResponse creates a response to parse from DeleteNotificationContacts response
func CreateDeleteNotificationContactsResponse() (response *DeleteNotificationContactsResponse) {
	response = &DeleteNotificationContactsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
