package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImageDetection invokes the green.ImageDetection API synchronously
// api document: https://help.aliyun.com/api/green/imagedetection.html
func (client *Client) ImageDetection(request *ImageDetectionRequest) (response *ImageDetectionResponse, err error) {
	response = CreateImageDetectionResponse()
	err = client.DoAction(request, response)
	return
}

// ImageDetectionWithChan invokes the green.ImageDetection API asynchronously
// api document: https://help.aliyun.com/api/green/imagedetection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImageDetectionWithChan(request *ImageDetectionRequest) (<-chan *ImageDetectionResponse, <-chan error) {
	responseChan := make(chan *ImageDetectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImageDetection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImageDetectionWithCallback invokes the green.ImageDetection API asynchronously
// api document: https://help.aliyun.com/api/green/imagedetection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImageDetectionWithCallback(request *ImageDetectionRequest, callback func(response *ImageDetectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImageDetectionResponse
		var err error
		defer close(result)
		response, err = client.ImageDetection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImageDetectionRequest is the request struct for api ImageDetection
type ImageDetectionRequest struct {
	*requests.RoaRequest
}

// ImageDetectionResponse is the response struct for api ImageDetection
type ImageDetectionResponse struct {
	*responses.BaseResponse
}

// CreateImageDetectionRequest creates a request to invoke ImageDetection API
func CreateImageDetectionRequest() (request *ImageDetectionRequest) {
	request = &ImageDetectionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2016-12-22", "ImageDetection", "/image/detection", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImageDetectionResponse creates a response to parse from ImageDetection response
func CreateImageDetectionResponse() (response *ImageDetectionResponse) {
	response = &ImageDetectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
