package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MarkOssResult invokes the green.MarkOssResult API synchronously
// api document: https://help.aliyun.com/api/green/markossresult.html
func (client *Client) MarkOssResult(request *MarkOssResultRequest) (response *MarkOssResultResponse, err error) {
	response = CreateMarkOssResultResponse()
	err = client.DoAction(request, response)
	return
}

// MarkOssResultWithChan invokes the green.MarkOssResult API asynchronously
// api document: https://help.aliyun.com/api/green/markossresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MarkOssResultWithChan(request *MarkOssResultRequest) (<-chan *MarkOssResultResponse, <-chan error) {
	responseChan := make(chan *MarkOssResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MarkOssResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MarkOssResultWithCallback invokes the green.MarkOssResult API asynchronously
// api document: https://help.aliyun.com/api/green/markossresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MarkOssResultWithCallback(request *MarkOssResultRequest, callback func(response *MarkOssResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MarkOssResultResponse
		var err error
		defer close(result)
		response, err = client.MarkOssResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MarkOssResultRequest is the request struct for api MarkOssResult
type MarkOssResultRequest struct {
	*requests.RpcRequest
	Scene        string           `position:"Query" name:"Scene"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Lang         string           `position:"Query" name:"Lang"`
	Stock        requests.Boolean `position:"Query" name:"Stock"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	Ids          string           `position:"Query" name:"Ids"`
	Operation    string           `position:"Query" name:"Operation"`
}

// MarkOssResultResponse is the response struct for api MarkOssResult
type MarkOssResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMarkOssResultRequest creates a request to invoke MarkOssResult API
func CreateMarkOssResultRequest() (request *MarkOssResultRequest) {
	request = &MarkOssResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "MarkOssResult", "green", "openAPI")
	return
}

// CreateMarkOssResultResponse creates a response to parse from MarkOssResult response
func CreateMarkOssResultResponse() (response *MarkOssResultResponse) {
	response = &MarkOssResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
