package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAppPackage invokes the green.UpdateAppPackage API synchronously
// api document: https://help.aliyun.com/api/green/updateapppackage.html
func (client *Client) UpdateAppPackage(request *UpdateAppPackageRequest) (response *UpdateAppPackageResponse, err error) {
	response = CreateUpdateAppPackageResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAppPackageWithChan invokes the green.UpdateAppPackage API asynchronously
// api document: https://help.aliyun.com/api/green/updateapppackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAppPackageWithChan(request *UpdateAppPackageRequest) (<-chan *UpdateAppPackageResponse, <-chan error) {
	responseChan := make(chan *UpdateAppPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAppPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAppPackageWithCallback invokes the green.UpdateAppPackage API asynchronously
// api document: https://help.aliyun.com/api/green/updateapppackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAppPackageWithCallback(request *UpdateAppPackageRequest, callback func(response *UpdateAppPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAppPackageResponse
		var err error
		defer close(result)
		response, err = client.UpdateAppPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAppPackageRequest is the request struct for api UpdateAppPackage
type UpdateAppPackageRequest struct {
	*requests.RpcRequest
	Debug      requests.Boolean `position:"Query" name:"Debug"`
	Platform   string           `position:"Query" name:"Platform"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	PackageUrl string           `position:"Query" name:"PackageUrl"`
	Id         requests.Integer `position:"Query" name:"Id"`
	Lang       string           `position:"Query" name:"Lang"`
}

// UpdateAppPackageResponse is the response struct for api UpdateAppPackage
type UpdateAppPackageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateUpdateAppPackageRequest creates a request to invoke UpdateAppPackage API
func CreateUpdateAppPackageRequest() (request *UpdateAppPackageRequest) {
	request = &UpdateAppPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateAppPackage", "green", "openAPI")
	return
}

// CreateUpdateAppPackageResponse creates a response to parse from UpdateAppPackage response
func CreateUpdateAppPackageResponse() (response *UpdateAppPackageResponse) {
	response = &UpdateAppPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
