package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VideoAsyncScanResults invokes the green.VideoAsyncScanResults API synchronously
// api document: https://help.aliyun.com/api/green/videoasyncscanresults.html
func (client *Client) VideoAsyncScanResults(request *VideoAsyncScanResultsRequest) (response *VideoAsyncScanResultsResponse, err error) {
	response = CreateVideoAsyncScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// VideoAsyncScanResultsWithChan invokes the green.VideoAsyncScanResults API asynchronously
// api document: https://help.aliyun.com/api/green/videoasyncscanresults.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VideoAsyncScanResultsWithChan(request *VideoAsyncScanResultsRequest) (<-chan *VideoAsyncScanResultsResponse, <-chan error) {
	responseChan := make(chan *VideoAsyncScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VideoAsyncScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VideoAsyncScanResultsWithCallback invokes the green.VideoAsyncScanResults API asynchronously
// api document: https://help.aliyun.com/api/green/videoasyncscanresults.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VideoAsyncScanResultsWithCallback(request *VideoAsyncScanResultsRequest, callback func(response *VideoAsyncScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VideoAsyncScanResultsResponse
		var err error
		defer close(result)
		response, err = client.VideoAsyncScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VideoAsyncScanResultsRequest is the request struct for api VideoAsyncScanResults
type VideoAsyncScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VideoAsyncScanResultsResponse is the response struct for api VideoAsyncScanResults
type VideoAsyncScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateVideoAsyncScanResultsRequest creates a request to invoke VideoAsyncScanResults API
func CreateVideoAsyncScanResultsRequest() (request *VideoAsyncScanResultsRequest) {
	request = &VideoAsyncScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VideoAsyncScanResults", "/green/video/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVideoAsyncScanResultsResponse creates a response to parse from VideoAsyncScanResults response
func CreateVideoAsyncScanResultsResponse() (response *VideoAsyncScanResultsResponse) {
	response = &VideoAsyncScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
