package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIpWhitelist invokes the hbase.ModifyIpWhitelist API synchronously
// api document: https://help.aliyun.com/api/hbase/modifyipwhitelist.html
func (client *Client) ModifyIpWhitelist(request *ModifyIpWhitelistRequest) (response *ModifyIpWhitelistResponse, err error) {
	response = CreateModifyIpWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIpWhitelistWithChan invokes the hbase.ModifyIpWhitelist API asynchronously
// api document: https://help.aliyun.com/api/hbase/modifyipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpWhitelistWithChan(request *ModifyIpWhitelistRequest) (<-chan *ModifyIpWhitelistResponse, <-chan error) {
	responseChan := make(chan *ModifyIpWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIpWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIpWhitelistWithCallback invokes the hbase.ModifyIpWhitelist API asynchronously
// api document: https://help.aliyun.com/api/hbase/modifyipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpWhitelistWithCallback(request *ModifyIpWhitelistRequest, callback func(response *ModifyIpWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIpWhitelistResponse
		var err error
		defer close(result)
		response, err = client.ModifyIpWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIpWhitelistRequest is the request struct for api ModifyIpWhitelist
type ModifyIpWhitelistRequest struct {
	*requests.RpcRequest
	IpList    string `position:"Query" name:"IpList"`
	IpVersion string `position:"Query" name:"IpVersion"`
	ClusterId string `position:"Query" name:"ClusterId"`
	GroupName string `position:"Query" name:"GroupName"`
}

// ModifyIpWhitelistResponse is the response struct for api ModifyIpWhitelist
type ModifyIpWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIpWhitelistRequest creates a request to invoke ModifyIpWhitelist API
func CreateModifyIpWhitelistRequest() (request *ModifyIpWhitelistRequest) {
	request = &ModifyIpWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyIpWhitelist", "hbase", "openAPI")
	return
}

// CreateModifyIpWhitelistResponse creates a response to parse from ModifyIpWhitelist response
func CreateModifyIpWhitelistResponse() (response *ModifyIpWhitelistResponse) {
	response = &ModifyIpWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
