package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUIAccountPassword invokes the hbase.ModifyUIAccountPassword API synchronously
// api document: https://help.aliyun.com/api/hbase/modifyuiaccountpassword.html
func (client *Client) ModifyUIAccountPassword(request *ModifyUIAccountPasswordRequest) (response *ModifyUIAccountPasswordResponse, err error) {
	response = CreateModifyUIAccountPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUIAccountPasswordWithChan invokes the hbase.ModifyUIAccountPassword API asynchronously
// api document: https://help.aliyun.com/api/hbase/modifyuiaccountpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUIAccountPasswordWithChan(request *ModifyUIAccountPasswordRequest) (<-chan *ModifyUIAccountPasswordResponse, <-chan error) {
	responseChan := make(chan *ModifyUIAccountPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUIAccountPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUIAccountPasswordWithCallback invokes the hbase.ModifyUIAccountPassword API asynchronously
// api document: https://help.aliyun.com/api/hbase/modifyuiaccountpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUIAccountPasswordWithCallback(request *ModifyUIAccountPasswordRequest, callback func(response *ModifyUIAccountPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUIAccountPasswordResponse
		var err error
		defer close(result)
		response, err = client.ModifyUIAccountPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUIAccountPasswordRequest is the request struct for api ModifyUIAccountPassword
type ModifyUIAccountPasswordRequest struct {
	*requests.RpcRequest
	ClusterId       string `position:"Query" name:"ClusterId"`
	AccountPassword string `position:"Query" name:"AccountPassword"`
	AccountName     string `position:"Query" name:"AccountName"`
}

// ModifyUIAccountPasswordResponse is the response struct for api ModifyUIAccountPassword
type ModifyUIAccountPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyUIAccountPasswordRequest creates a request to invoke ModifyUIAccountPassword API
func CreateModifyUIAccountPasswordRequest() (request *ModifyUIAccountPasswordRequest) {
	request = &ModifyUIAccountPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyUIAccountPassword", "hbase", "openAPI")
	return
}

// CreateModifyUIAccountPasswordResponse creates a response to parse from ModifyUIAccountPassword response
func CreateModifyUIAccountPasswordResponse() (response *ModifyUIAccountPasswordResponse) {
	response = &ModifyUIAccountPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
