package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchHbaseHaSlb invokes the hbase.SwitchHbaseHaSlb API synchronously
// api document: https://help.aliyun.com/api/hbase/switchhbasehaslb.html
func (client *Client) SwitchHbaseHaSlb(request *SwitchHbaseHaSlbRequest) (response *SwitchHbaseHaSlbResponse, err error) {
	response = CreateSwitchHbaseHaSlbResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchHbaseHaSlbWithChan invokes the hbase.SwitchHbaseHaSlb API asynchronously
// api document: https://help.aliyun.com/api/hbase/switchhbasehaslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchHbaseHaSlbWithChan(request *SwitchHbaseHaSlbRequest) (<-chan *SwitchHbaseHaSlbResponse, <-chan error) {
	responseChan := make(chan *SwitchHbaseHaSlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchHbaseHaSlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchHbaseHaSlbWithCallback invokes the hbase.SwitchHbaseHaSlb API asynchronously
// api document: https://help.aliyun.com/api/hbase/switchhbasehaslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchHbaseHaSlbWithCallback(request *SwitchHbaseHaSlbRequest, callback func(response *SwitchHbaseHaSlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchHbaseHaSlbResponse
		var err error
		defer close(result)
		response, err = client.SwitchHbaseHaSlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchHbaseHaSlbRequest is the request struct for api SwitchHbaseHaSlb
type SwitchHbaseHaSlbRequest struct {
	*requests.RpcRequest
	HaTypes   string `position:"Query" name:"HaTypes"`
	HbaseType string `position:"Query" name:"HbaseType"`
	BdsId     string `position:"Query" name:"BdsId"`
	HaId      string `position:"Query" name:"HaId"`
}

// SwitchHbaseHaSlbResponse is the response struct for api SwitchHbaseHaSlb
type SwitchHbaseHaSlbResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchHbaseHaSlbRequest creates a request to invoke SwitchHbaseHaSlb API
func CreateSwitchHbaseHaSlbRequest() (request *SwitchHbaseHaSlbRequest) {
	request = &SwitchHbaseHaSlbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "SwitchHbaseHaSlb", "hbase", "openAPI")
	return
}

// CreateSwitchHbaseHaSlbResponse creates a response to parse from SwitchHbaseHaSlb response
func CreateSwitchHbaseHaSlbResponse() (response *SwitchHbaseHaSlbResponse) {
	response = &SwitchHbaseHaSlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
