package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// XpackRelateDB invokes the hbase.XpackRelateDB API synchronously
// api document: https://help.aliyun.com/api/hbase/xpackrelatedb.html
func (client *Client) XpackRelateDB(request *XpackRelateDBRequest) (response *XpackRelateDBResponse, err error) {
	response = CreateXpackRelateDBResponse()
	err = client.DoAction(request, response)
	return
}

// XpackRelateDBWithChan invokes the hbase.XpackRelateDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/xpackrelatedb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) XpackRelateDBWithChan(request *XpackRelateDBRequest) (<-chan *XpackRelateDBResponse, <-chan error) {
	responseChan := make(chan *XpackRelateDBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.XpackRelateDB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// XpackRelateDBWithCallback invokes the hbase.XpackRelateDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/xpackrelatedb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) XpackRelateDBWithCallback(request *XpackRelateDBRequest, callback func(response *XpackRelateDBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *XpackRelateDBResponse
		var err error
		defer close(result)
		response, err = client.XpackRelateDB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// XpackRelateDBRequest is the request struct for api XpackRelateDB
type XpackRelateDBRequest struct {
	*requests.RpcRequest
	ClusterId    string `position:"Query" name:"ClusterId"`
	RelateDbType string `position:"Query" name:"RelateDbType"`
	DbClusterIds string `position:"Query" name:"DbClusterIds"`
}

// XpackRelateDBResponse is the response struct for api XpackRelateDB
type XpackRelateDBResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateXpackRelateDBRequest creates a request to invoke XpackRelateDB API
func CreateXpackRelateDBRequest() (request *XpackRelateDBRequest) {
	request = &XpackRelateDBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "XpackRelateDB", "hbase", "openAPI")
	return
}

// CreateXpackRelateDBResponse creates a response to parse from XpackRelateDB response
func CreateXpackRelateDBResponse() (response *XpackRelateDBResponse) {
	response = &XpackRelateDBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
