package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchGetDeviceState invokes the iot.BatchGetDeviceState API synchronously
// api document: https://help.aliyun.com/api/iot/batchgetdevicestate.html
func (client *Client) BatchGetDeviceState(request *BatchGetDeviceStateRequest) (response *BatchGetDeviceStateResponse, err error) {
	response = CreateBatchGetDeviceStateResponse()
	err = client.DoAction(request, response)
	return
}

// BatchGetDeviceStateWithChan invokes the iot.BatchGetDeviceState API asynchronously
// api document: https://help.aliyun.com/api/iot/batchgetdevicestate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchGetDeviceStateWithChan(request *BatchGetDeviceStateRequest) (<-chan *BatchGetDeviceStateResponse, <-chan error) {
	responseChan := make(chan *BatchGetDeviceStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchGetDeviceState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchGetDeviceStateWithCallback invokes the iot.BatchGetDeviceState API asynchronously
// api document: https://help.aliyun.com/api/iot/batchgetdevicestate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchGetDeviceStateWithCallback(request *BatchGetDeviceStateRequest, callback func(response *BatchGetDeviceStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchGetDeviceStateResponse
		var err error
		defer close(result)
		response, err = client.BatchGetDeviceState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchGetDeviceStateRequest is the request struct for api BatchGetDeviceState
type BatchGetDeviceStateRequest struct {
	*requests.RpcRequest
	ProductKey    string    `position:"Query" name:"ProductKey"`
	IotId         *[]string `position:"Query" name:"IotId"  type:"Repeated"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	DeviceName    *[]string `position:"Query" name:"DeviceName"  type:"Repeated"`
}

// BatchGetDeviceStateResponse is the response struct for api BatchGetDeviceState
type BatchGetDeviceStateResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Success          bool             `json:"Success" xml:"Success"`
	Code             string           `json:"Code" xml:"Code"`
	ErrorMessage     string           `json:"ErrorMessage" xml:"ErrorMessage"`
	DeviceStatusList DeviceStatusList `json:"DeviceStatusList" xml:"DeviceStatusList"`
}

// CreateBatchGetDeviceStateRequest creates a request to invoke BatchGetDeviceState API
func CreateBatchGetDeviceStateRequest() (request *BatchGetDeviceStateRequest) {
	request = &BatchGetDeviceStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchGetDeviceState", "iot", "openAPI")
	return
}

// CreateBatchGetDeviceStateResponse creates a response to parse from BatchGetDeviceState response
func CreateBatchGetDeviceStateResponse() (response *BatchGetDeviceStateResponse) {
	response = &BatchGetDeviceStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
