package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveDeviceProp invokes the iot.SaveDeviceProp API synchronously
// api document: https://help.aliyun.com/api/iot/savedeviceprop.html
func (client *Client) SaveDeviceProp(request *SaveDevicePropRequest) (response *SaveDevicePropResponse, err error) {
	response = CreateSaveDevicePropResponse()
	err = client.DoAction(request, response)
	return
}

// SaveDevicePropWithChan invokes the iot.SaveDeviceProp API asynchronously
// api document: https://help.aliyun.com/api/iot/savedeviceprop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveDevicePropWithChan(request *SaveDevicePropRequest) (<-chan *SaveDevicePropResponse, <-chan error) {
	responseChan := make(chan *SaveDevicePropResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveDeviceProp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveDevicePropWithCallback invokes the iot.SaveDeviceProp API asynchronously
// api document: https://help.aliyun.com/api/iot/savedeviceprop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveDevicePropWithCallback(request *SaveDevicePropRequest, callback func(response *SaveDevicePropResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveDevicePropResponse
		var err error
		defer close(result)
		response, err = client.SaveDeviceProp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveDevicePropRequest is the request struct for api SaveDeviceProp
type SaveDevicePropRequest struct {
	*requests.RpcRequest
	ProductKey    string `position:"Query" name:"ProductKey"`
	Props         string `position:"Query" name:"Props"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// SaveDevicePropResponse is the response struct for api SaveDeviceProp
type SaveDevicePropResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateSaveDevicePropRequest creates a request to invoke SaveDeviceProp API
func CreateSaveDevicePropRequest() (request *SaveDevicePropRequest) {
	request = &SaveDevicePropRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "SaveDeviceProp", "iot", "openAPI")
	return
}

// CreateSaveDevicePropResponse creates a response to parse from SaveDeviceProp response
func CreateSaveDevicePropResponse() (response *SaveDevicePropResponse) {
	response = &SaveDevicePropResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
