package ivpd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeImageColor invokes the ivpd.RecognizeImageColor API synchronously
// api document: https://help.aliyun.com/api/ivpd/recognizeimagecolor.html
func (client *Client) RecognizeImageColor(request *RecognizeImageColorRequest) (response *RecognizeImageColorResponse, err error) {
	response = CreateRecognizeImageColorResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeImageColorWithChan invokes the ivpd.RecognizeImageColor API asynchronously
// api document: https://help.aliyun.com/api/ivpd/recognizeimagecolor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeImageColorWithChan(request *RecognizeImageColorRequest) (<-chan *RecognizeImageColorResponse, <-chan error) {
	responseChan := make(chan *RecognizeImageColorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeImageColor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeImageColorWithCallback invokes the ivpd.RecognizeImageColor API asynchronously
// api document: https://help.aliyun.com/api/ivpd/recognizeimagecolor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeImageColorWithCallback(request *RecognizeImageColorRequest, callback func(response *RecognizeImageColorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeImageColorResponse
		var err error
		defer close(result)
		response, err = client.RecognizeImageColor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeImageColorRequest is the request struct for api RecognizeImageColor
type RecognizeImageColorRequest struct {
	*requests.RpcRequest
	Url        string `position:"Body" name:"Url"`
	ColorCount string `position:"Body" name:"ColorCount"`
}

// RecognizeImageColorResponse is the response struct for api RecognizeImageColor
type RecognizeImageColorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeImageColorRequest creates a request to invoke RecognizeImageColor API
func CreateRecognizeImageColorRequest() (request *RecognizeImageColorRequest) {
	request = &RecognizeImageColorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivpd", "2019-06-25", "RecognizeImageColor", "ivpd", "openAPI")
	return
}

// CreateRecognizeImageColorResponse creates a response to parse from RecognizeImageColor response
func CreateRecognizeImageColorResponse() (response *RecognizeImageColorResponse) {
	response = &RecognizeImageColorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
