package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveRealTimeLogLogstore invokes the live.DeleteLiveRealTimeLogLogstore API synchronously
// api document: https://help.aliyun.com/api/live/deleteliverealtimeloglogstore.html
func (client *Client) DeleteLiveRealTimeLogLogstore(request *DeleteLiveRealTimeLogLogstoreRequest) (response *DeleteLiveRealTimeLogLogstoreResponse, err error) {
	response = CreateDeleteLiveRealTimeLogLogstoreResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveRealTimeLogLogstoreWithChan invokes the live.DeleteLiveRealTimeLogLogstore API asynchronously
// api document: https://help.aliyun.com/api/live/deleteliverealtimeloglogstore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveRealTimeLogLogstoreWithChan(request *DeleteLiveRealTimeLogLogstoreRequest) (<-chan *DeleteLiveRealTimeLogLogstoreResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveRealTimeLogLogstoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveRealTimeLogLogstore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveRealTimeLogLogstoreWithCallback invokes the live.DeleteLiveRealTimeLogLogstore API asynchronously
// api document: https://help.aliyun.com/api/live/deleteliverealtimeloglogstore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveRealTimeLogLogstoreWithCallback(request *DeleteLiveRealTimeLogLogstoreRequest, callback func(response *DeleteLiveRealTimeLogLogstoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveRealTimeLogLogstoreResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveRealTimeLogLogstore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveRealTimeLogLogstoreRequest is the request struct for api DeleteLiveRealTimeLogLogstore
type DeleteLiveRealTimeLogLogstoreRequest struct {
	*requests.RpcRequest
	Project  string           `position:"Query" name:"Project"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	Region   string           `position:"Query" name:"Region"`
	Logstore string           `position:"Query" name:"Logstore"`
}

// DeleteLiveRealTimeLogLogstoreResponse is the response struct for api DeleteLiveRealTimeLogLogstore
type DeleteLiveRealTimeLogLogstoreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveRealTimeLogLogstoreRequest creates a request to invoke DeleteLiveRealTimeLogLogstore API
func CreateDeleteLiveRealTimeLogLogstoreRequest() (request *DeleteLiveRealTimeLogLogstoreRequest) {
	request = &DeleteLiveRealTimeLogLogstoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveRealTimeLogLogstore", "live", "openAPI")
	return
}

// CreateDeleteLiveRealTimeLogLogstoreResponse creates a response to parse from DeleteLiveRealTimeLogLogstore response
func CreateDeleteLiveRealTimeLogLogstoreResponse() (response *DeleteLiveRealTimeLogLogstoreResponse) {
	response = &DeleteLiveRealTimeLogLogstoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
