package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveRealtimeDeliveryAcc invokes the live.DescribeLiveRealtimeDeliveryAcc API synchronously
// api document: https://help.aliyun.com/api/live/describeliverealtimedeliveryacc.html
func (client *Client) DescribeLiveRealtimeDeliveryAcc(request *DescribeLiveRealtimeDeliveryAccRequest) (response *DescribeLiveRealtimeDeliveryAccResponse, err error) {
	response = CreateDescribeLiveRealtimeDeliveryAccResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveRealtimeDeliveryAccWithChan invokes the live.DescribeLiveRealtimeDeliveryAcc API asynchronously
// api document: https://help.aliyun.com/api/live/describeliverealtimedeliveryacc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveRealtimeDeliveryAccWithChan(request *DescribeLiveRealtimeDeliveryAccRequest) (<-chan *DescribeLiveRealtimeDeliveryAccResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveRealtimeDeliveryAccResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveRealtimeDeliveryAcc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveRealtimeDeliveryAccWithCallback invokes the live.DescribeLiveRealtimeDeliveryAcc API asynchronously
// api document: https://help.aliyun.com/api/live/describeliverealtimedeliveryacc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveRealtimeDeliveryAccWithCallback(request *DescribeLiveRealtimeDeliveryAccRequest, callback func(response *DescribeLiveRealtimeDeliveryAccResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveRealtimeDeliveryAccResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveRealtimeDeliveryAcc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveRealtimeDeliveryAccRequest is the request struct for api DescribeLiveRealtimeDeliveryAcc
type DescribeLiveRealtimeDeliveryAccRequest struct {
	*requests.RpcRequest
	Project   string           `position:"Query" name:"Project"`
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Interval  string           `position:"Query" name:"Interval"`
	LogStore  string           `position:"Query" name:"LogStore"`
}

// DescribeLiveRealtimeDeliveryAccResponse is the response struct for api DescribeLiveRealtimeDeliveryAcc
type DescribeLiveRealtimeDeliveryAccResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	RealTimeDeliveryAccData RealTimeDeliveryAccData `json:"RealTimeDeliveryAccData" xml:"RealTimeDeliveryAccData"`
}

// CreateDescribeLiveRealtimeDeliveryAccRequest creates a request to invoke DescribeLiveRealtimeDeliveryAcc API
func CreateDescribeLiveRealtimeDeliveryAccRequest() (request *DescribeLiveRealtimeDeliveryAccRequest) {
	request = &DescribeLiveRealtimeDeliveryAccRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveRealtimeDeliveryAcc", "live", "openAPI")
	return
}

// CreateDescribeLiveRealtimeDeliveryAccResponse creates a response to parse from DescribeLiveRealtimeDeliveryAcc response
func CreateDescribeLiveRealtimeDeliveryAccResponse() (response *DescribeLiveRealtimeDeliveryAccResponse) {
	response = &DescribeLiveRealtimeDeliveryAccResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
