package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveRecordVodConfigs invokes the live.DescribeLiveRecordVodConfigs API synchronously
// api document: https://help.aliyun.com/api/live/describeliverecordvodconfigs.html
func (client *Client) DescribeLiveRecordVodConfigs(request *DescribeLiveRecordVodConfigsRequest) (response *DescribeLiveRecordVodConfigsResponse, err error) {
	response = CreateDescribeLiveRecordVodConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveRecordVodConfigsWithChan invokes the live.DescribeLiveRecordVodConfigs API asynchronously
// api document: https://help.aliyun.com/api/live/describeliverecordvodconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveRecordVodConfigsWithChan(request *DescribeLiveRecordVodConfigsRequest) (<-chan *DescribeLiveRecordVodConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveRecordVodConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveRecordVodConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveRecordVodConfigsWithCallback invokes the live.DescribeLiveRecordVodConfigs API asynchronously
// api document: https://help.aliyun.com/api/live/describeliverecordvodconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveRecordVodConfigsWithCallback(request *DescribeLiveRecordVodConfigsRequest, callback func(response *DescribeLiveRecordVodConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveRecordVodConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveRecordVodConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveRecordVodConfigsRequest is the request struct for api DescribeLiveRecordVodConfigs
type DescribeLiveRecordVodConfigsRequest struct {
	*requests.RpcRequest
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
	AppName    string           `position:"Query" name:"AppName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveRecordVodConfigsResponse is the response struct for api DescribeLiveRecordVodConfigs
type DescribeLiveRecordVodConfigsResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	PageNum              int                  `json:"PageNum" xml:"PageNum"`
	PageSize             int                  `json:"PageSize" xml:"PageSize"`
	Total                string               `json:"Total" xml:"Total"`
	LiveRecordVodConfigs LiveRecordVodConfigs `json:"LiveRecordVodConfigs" xml:"LiveRecordVodConfigs"`
}

// CreateDescribeLiveRecordVodConfigsRequest creates a request to invoke DescribeLiveRecordVodConfigs API
func CreateDescribeLiveRecordVodConfigsRequest() (request *DescribeLiveRecordVodConfigsRequest) {
	request = &DescribeLiveRecordVodConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveRecordVodConfigs", "live", "openAPI")
	return
}

// CreateDescribeLiveRecordVodConfigsResponse creates a response to parse from DescribeLiveRecordVodConfigs response
func CreateDescribeLiveRecordVodConfigsResponse() (response *DescribeLiveRecordVodConfigsResponse) {
	response = &DescribeLiveRecordVodConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
