package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamsFrameRateAndBitRateData invokes the live.DescribeLiveStreamsFrameRateAndBitRateData API synchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsframerateandbitratedata.html
func (client *Client) DescribeLiveStreamsFrameRateAndBitRateData(request *DescribeLiveStreamsFrameRateAndBitRateDataRequest) (response *DescribeLiveStreamsFrameRateAndBitRateDataResponse, err error) {
	response = CreateDescribeLiveStreamsFrameRateAndBitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamsFrameRateAndBitRateDataWithChan invokes the live.DescribeLiveStreamsFrameRateAndBitRateData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsframerateandbitratedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsFrameRateAndBitRateDataWithChan(request *DescribeLiveStreamsFrameRateAndBitRateDataRequest) (<-chan *DescribeLiveStreamsFrameRateAndBitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamsFrameRateAndBitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamsFrameRateAndBitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamsFrameRateAndBitRateDataWithCallback invokes the live.DescribeLiveStreamsFrameRateAndBitRateData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsframerateandbitratedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsFrameRateAndBitRateDataWithCallback(request *DescribeLiveStreamsFrameRateAndBitRateDataRequest, callback func(response *DescribeLiveStreamsFrameRateAndBitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamsFrameRateAndBitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamsFrameRateAndBitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamsFrameRateAndBitRateDataRequest is the request struct for api DescribeLiveStreamsFrameRateAndBitRateData
type DescribeLiveStreamsFrameRateAndBitRateDataRequest struct {
	*requests.RpcRequest
	StartTime     string           `position:"Query" name:"StartTime"`
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	StreamName    string           `position:"Query" name:"StreamName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	EndTime       string           `position:"Query" name:"EndTime"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamsFrameRateAndBitRateDataResponse is the response struct for api DescribeLiveStreamsFrameRateAndBitRateData
type DescribeLiveStreamsFrameRateAndBitRateDataResponse struct {
	*responses.BaseResponse
	RequestId                string                                                               `json:"RequestId" xml:"RequestId"`
	FrameRateAndBitRateInfos FrameRateAndBitRateInfosInDescribeLiveStreamsFrameRateAndBitRateData `json:"FrameRateAndBitRateInfos" xml:"FrameRateAndBitRateInfos"`
}

// CreateDescribeLiveStreamsFrameRateAndBitRateDataRequest creates a request to invoke DescribeLiveStreamsFrameRateAndBitRateData API
func CreateDescribeLiveStreamsFrameRateAndBitRateDataRequest() (request *DescribeLiveStreamsFrameRateAndBitRateDataRequest) {
	request = &DescribeLiveStreamsFrameRateAndBitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamsFrameRateAndBitRateData", "live", "openAPI")
	return
}

// CreateDescribeLiveStreamsFrameRateAndBitRateDataResponse creates a response to parse from DescribeLiveStreamsFrameRateAndBitRateData response
func CreateDescribeLiveStreamsFrameRateAndBitRateDataResponse() (response *DescribeLiveStreamsFrameRateAndBitRateDataResponse) {
	response = &DescribeLiveStreamsFrameRateAndBitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
