package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveRealtimeLogDelivery invokes the live.ListLiveRealtimeLogDelivery API synchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdelivery.html
func (client *Client) ListLiveRealtimeLogDelivery(request *ListLiveRealtimeLogDeliveryRequest) (response *ListLiveRealtimeLogDeliveryResponse, err error) {
	response = CreateListLiveRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveRealtimeLogDeliveryWithChan invokes the live.ListLiveRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryWithChan(request *ListLiveRealtimeLogDeliveryRequest) (<-chan *ListLiveRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *ListLiveRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveRealtimeLogDeliveryWithCallback invokes the live.ListLiveRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryWithCallback(request *ListLiveRealtimeLogDeliveryRequest, callback func(response *ListLiveRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.ListLiveRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveRealtimeLogDeliveryRequest is the request struct for api ListLiveRealtimeLogDelivery
type ListLiveRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	LiveOpenapiReserve string           `position:"Query" name:"LiveOpenapiReserve"`
}

// ListLiveRealtimeLogDeliveryResponse is the response struct for api ListLiveRealtimeLogDelivery
type ListLiveRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	Content   ContentInListLiveRealtimeLogDelivery `json:"Content" xml:"Content"`
}

// CreateListLiveRealtimeLogDeliveryRequest creates a request to invoke ListLiveRealtimeLogDelivery API
func CreateListLiveRealtimeLogDeliveryRequest() (request *ListLiveRealtimeLogDeliveryRequest) {
	request = &ListLiveRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveRealtimeLogDelivery", "live", "openAPI")
	return
}

// CreateListLiveRealtimeLogDeliveryResponse creates a response to parse from ListLiveRealtimeLogDelivery response
func CreateListLiveRealtimeLogDeliveryResponse() (response *ListLiveRealtimeLogDeliveryResponse) {
	response = &ListLiveRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
