package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartLiveDomain invokes the live.StartLiveDomain API synchronously
// api document: https://help.aliyun.com/api/live/startlivedomain.html
func (client *Client) StartLiveDomain(request *StartLiveDomainRequest) (response *StartLiveDomainResponse, err error) {
	response = CreateStartLiveDomainResponse()
	err = client.DoAction(request, response)
	return
}

// StartLiveDomainWithChan invokes the live.StartLiveDomain API asynchronously
// api document: https://help.aliyun.com/api/live/startlivedomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartLiveDomainWithChan(request *StartLiveDomainRequest) (<-chan *StartLiveDomainResponse, <-chan error) {
	responseChan := make(chan *StartLiveDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartLiveDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartLiveDomainWithCallback invokes the live.StartLiveDomain API asynchronously
// api document: https://help.aliyun.com/api/live/startlivedomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartLiveDomainWithCallback(request *StartLiveDomainRequest, callback func(response *StartLiveDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartLiveDomainResponse
		var err error
		defer close(result)
		response, err = client.StartLiveDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartLiveDomainRequest is the request struct for api StartLiveDomain
type StartLiveDomainRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// StartLiveDomainResponse is the response struct for api StartLiveDomain
type StartLiveDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartLiveDomainRequest creates a request to invoke StartLiveDomain API
func CreateStartLiveDomainRequest() (request *StartLiveDomainRequest) {
	request = &StartLiveDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StartLiveDomain", "live", "openAPI")
	return
}

// CreateStartLiveDomainResponse creates a response to parse from StartLiveDomain response
func CreateStartLiveDomainResponse() (response *StartLiveDomainResponse) {
	response = &StartLiveDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
