//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveClientFromBlackList invokes the nas.RemoveClientFromBlackList API synchronously
// api document: https://help.aliyun.com/api/nas/removeclientfromblacklist.html
func (client *Client) RemoveClientFromBlackList(request *RemoveClientFromBlackListRequest) (response *RemoveClientFromBlackListResponse, err error) {
	response = CreateRemoveClientFromBlackListResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveClientFromBlackListWithChan invokes the nas.RemoveClientFromBlackList API asynchronously
// api document: https://help.aliyun.com/api/nas/removeclientfromblacklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveClientFromBlackListWithChan(request *RemoveClientFromBlackListRequest) (<-chan *RemoveClientFromBlackListResponse, <-chan error) {
	responseChan := make(chan *RemoveClientFromBlackListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveClientFromBlackList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveClientFromBlackListWithCallback invokes the nas.RemoveClientFromBlackList API asynchronously
// api document: https://help.aliyun.com/api/nas/removeclientfromblacklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveClientFromBlackListWithCallback(request *RemoveClientFromBlackListRequest, callback func(response *RemoveClientFromBlackListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveClientFromBlackListResponse
		var err error
		defer close(result)
		response, err = client.RemoveClientFromBlackList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveClientFromBlackListRequest is the request struct for api RemoveClientFromBlackList
type RemoveClientFromBlackListRequest struct {
	*requests.RpcRequest
	RegionId     string `position:"Query" name:"RegionId"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
	ClientIP     string `position:"Query" name:"ClientIP"`
	ClientToken  string `position:"Query" name:"ClientToken"`
}

// RemoveClientFromBlackListResponse is the response struct for api RemoveClientFromBlackList
type RemoveClientFromBlackListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveClientFromBlackListRequest creates a request to invoke RemoveClientFromBlackList API
func CreateRemoveClientFromBlackListRequest() (request *RemoveClientFromBlackListRequest) {
	request = &RemoveClientFromBlackListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "RemoveClientFromBlackList", "nas", "openAPI")
	return
}

// CreateRemoveClientFromBlackListResponse creates a response to parse from RemoveClientFromBlackList response
func CreateRemoveClientFromBlackListResponse() (response *RemoveClientFromBlackListResponse) {
	response = &RemoveClientFromBlackListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
