package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoLogicalDeleteResource invokes the qualitycheck.DoLogicalDeleteResource API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/dologicaldeleteresource.html
func (client *Client) DoLogicalDeleteResource(request *DoLogicalDeleteResourceRequest) (response *DoLogicalDeleteResourceResponse, err error) {
	response = CreateDoLogicalDeleteResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DoLogicalDeleteResourceWithChan invokes the qualitycheck.DoLogicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/dologicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoLogicalDeleteResourceWithChan(request *DoLogicalDeleteResourceRequest) (<-chan *DoLogicalDeleteResourceResponse, <-chan error) {
	responseChan := make(chan *DoLogicalDeleteResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoLogicalDeleteResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoLogicalDeleteResourceWithCallback invokes the qualitycheck.DoLogicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/dologicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoLogicalDeleteResourceWithCallback(request *DoLogicalDeleteResourceRequest, callback func(response *DoLogicalDeleteResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoLogicalDeleteResourceResponse
		var err error
		defer close(result)
		response, err = client.DoLogicalDeleteResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoLogicalDeleteResourceRequest is the request struct for api DoLogicalDeleteResource
type DoLogicalDeleteResourceRequest struct {
	*requests.RpcRequest
	Country         string           `position:"Query" name:"Country"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Hid             requests.Integer `position:"Query" name:"Hid"`
	Message         string           `position:"Query" name:"Message"`
	Success         requests.Boolean `position:"Query" name:"Success"`
	Interrupt       requests.Boolean `position:"Query" name:"Interrupt"`
	GmtWakeup       string           `position:"Query" name:"GmtWakeup"`
	Pk              string           `position:"Query" name:"Pk"`
	Bid             string           `position:"Query" name:"Bid"`
	TaskExtraData   string           `position:"Query" name:"TaskExtraData"`
	TaskIdentifier  string           `position:"Query" name:"TaskIdentifier"`
}

// DoLogicalDeleteResourceResponse is the response struct for api DoLogicalDeleteResource
type DoLogicalDeleteResourceResponse struct {
	*responses.BaseResponse
	Interrupt      string `json:"Interrupt" xml:"Interrupt"`
	Invoker        int64  `json:"Invoker" xml:"Invoker"`
	Pk             string `json:"Pk" xml:"Pk"`
	Bid            string `json:"Bid" xml:"Bid"`
	Hid            int64  `json:"Hid" xml:"Hid"`
	Country        string `json:"Country" xml:"Country"`
	TaskIdentifier string `json:"TaskIdentifier" xml:"TaskIdentifier"`
	GmtWakeup      string `json:"GmtWakeup" xml:"GmtWakeup"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateDoLogicalDeleteResourceRequest creates a request to invoke DoLogicalDeleteResource API
func CreateDoLogicalDeleteResourceRequest() (request *DoLogicalDeleteResourceRequest) {
	request = &DoLogicalDeleteResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DoLogicalDeleteResource", "", "")
	return
}

// CreateDoLogicalDeleteResourceResponse creates a response to parse from DoLogicalDeleteResource response
func CreateDoLogicalDeleteResourceResponse() (response *DoLogicalDeleteResourceResponse) {
	response = &DoLogicalDeleteResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
