package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCustomizationConfigList invokes the qualitycheck.GetCustomizationConfigList API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/getcustomizationconfiglist.html
func (client *Client) GetCustomizationConfigList(request *GetCustomizationConfigListRequest) (response *GetCustomizationConfigListResponse, err error) {
	response = CreateGetCustomizationConfigListResponse()
	err = client.DoAction(request, response)
	return
}

// GetCustomizationConfigListWithChan invokes the qualitycheck.GetCustomizationConfigList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getcustomizationconfiglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomizationConfigListWithChan(request *GetCustomizationConfigListRequest) (<-chan *GetCustomizationConfigListResponse, <-chan error) {
	responseChan := make(chan *GetCustomizationConfigListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCustomizationConfigList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCustomizationConfigListWithCallback invokes the qualitycheck.GetCustomizationConfigList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getcustomizationconfiglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomizationConfigListWithCallback(request *GetCustomizationConfigListRequest, callback func(response *GetCustomizationConfigListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCustomizationConfigListResponse
		var err error
		defer close(result)
		response, err = client.GetCustomizationConfigList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCustomizationConfigListRequest is the request struct for api GetCustomizationConfigList
type GetCustomizationConfigListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetCustomizationConfigListResponse is the response struct for api GetCustomizationConfigList
type GetCustomizationConfigListResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Success   bool                             `json:"Success" xml:"Success"`
	Code      string                           `json:"Code" xml:"Code"`
	Message   string                           `json:"Message" xml:"Message"`
	Data      DataInGetCustomizationConfigList `json:"Data" xml:"Data"`
}

// CreateGetCustomizationConfigListRequest creates a request to invoke GetCustomizationConfigList API
func CreateGetCustomizationConfigListRequest() (request *GetCustomizationConfigListRequest) {
	request = &GetCustomizationConfigListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetCustomizationConfigList", "", "")
	return
}

// CreateGetCustomizationConfigListResponse creates a response to parse from GetCustomizationConfigList response
func CreateGetCustomizationConfigListResponse() (response *GetCustomizationConfigListResponse) {
	response = &GetCustomizationConfigListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
