package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRecognizeResult invokes the qualitycheck.GetRecognizeResult API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/getrecognizeresult.html
func (client *Client) GetRecognizeResult(request *GetRecognizeResultRequest) (response *GetRecognizeResultResponse, err error) {
	response = CreateGetRecognizeResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetRecognizeResultWithChan invokes the qualitycheck.GetRecognizeResult API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getrecognizeresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRecognizeResultWithChan(request *GetRecognizeResultRequest) (<-chan *GetRecognizeResultResponse, <-chan error) {
	responseChan := make(chan *GetRecognizeResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRecognizeResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRecognizeResultWithCallback invokes the qualitycheck.GetRecognizeResult API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getrecognizeresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRecognizeResultWithCallback(request *GetRecognizeResultRequest, callback func(response *GetRecognizeResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRecognizeResultResponse
		var err error
		defer close(result)
		response, err = client.GetRecognizeResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRecognizeResultRequest is the request struct for api GetRecognizeResult
type GetRecognizeResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetRecognizeResultResponse is the response struct for api GetRecognizeResult
type GetRecognizeResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetRecognizeResultRequest creates a request to invoke GetRecognizeResult API
func CreateGetRecognizeResultRequest() (request *GetRecognizeResultRequest) {
	request = &GetRecognizeResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetRecognizeResult", "", "")
	return
}

// CreateGetRecognizeResultResponse creates a response to parse from GetRecognizeResult response
func CreateGetRecognizeResultResponse() (response *GetRecognizeResultResponse) {
	response = &GetRecognizeResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
