package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterNotice invokes the qualitycheck.RegisterNotice API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/registernotice.html
func (client *Client) RegisterNotice(request *RegisterNoticeRequest) (response *RegisterNoticeResponse, err error) {
	response = CreateRegisterNoticeResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterNoticeWithChan invokes the qualitycheck.RegisterNotice API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/registernotice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterNoticeWithChan(request *RegisterNoticeRequest) (<-chan *RegisterNoticeResponse, <-chan error) {
	responseChan := make(chan *RegisterNoticeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterNotice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterNoticeWithCallback invokes the qualitycheck.RegisterNotice API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/registernotice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterNoticeWithCallback(request *RegisterNoticeRequest, callback func(response *RegisterNoticeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterNoticeResponse
		var err error
		defer close(result)
		response, err = client.RegisterNotice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterNoticeRequest is the request struct for api RegisterNotice
type RegisterNoticeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// RegisterNoticeResponse is the response struct for api RegisterNotice
type RegisterNoticeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateRegisterNoticeRequest creates a request to invoke RegisterNotice API
func CreateRegisterNoticeRequest() (request *RegisterNoticeRequest) {
	request = &RegisterNoticeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "RegisterNotice", "", "")
	return
}

// CreateRegisterNoticeResponse creates a response to parse from RegisterNotice response
func CreateRegisterNoticeResponse() (response *RegisterNoticeResponse) {
	response = &RegisterNoticeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
